/*
 * Decompiled with CFR 0.152.
 */
package api.quotation.module;

import api.quotation.bean.Tick;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import util.bean.UpbitResponse;
import util.constant.ApiList;
import util.module.Util;

public class TradesApi {
    public UpbitResponse<Tick[]> getTicks(String market) throws IOException {
        return this.getTicks(market, "", 1, "", 0);
    }

    public UpbitResponse<Tick[]> getTicks(String market, String to, int count, String cursor, int daysAgo) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("to", to);
        params.put("count", String.valueOf(count));
        params.put("cursor", cursor);
        params.put("daysAgo", String.valueOf(daysAgo));
        URL url = new URL(Util.builder(ApiList.TRADES.getUrl(), "/ticks?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        UpbitResponse<Tick[]> response = new UpbitResponse<Tick[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Tick[] ticks = (Tick[])new Gson().fromJson(responseBuilder.toString(), Tick[].class);
            response.setSuccess(true);
            response.setBody(ticks);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }
}

