/*
 * Decompiled with CFR 0.152.
 */
package api.exchange.module;

import api.exchange.bean.Account;
import api.exchange.module.AuthApi;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import util.bean.UpbitResponse;
import util.constant.ApiList;
import util.module.Util;

public class AccountsApi
extends AuthApi {
    public AccountsApi(String api, String secret) {
        super(api, secret);
    }

    public UpbitResponse<Account[]> getAccounts() throws IOException {
        URL url = new URL(Util.builder(ApiList.ACCOUNTS.getUrl()));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken()));
        UpbitResponse<Account[]> response = new UpbitResponse<Account[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Account[] accounts = (Account[])new Gson().fromJson(responseBuilder.toString(), Account[].class);
            response.setSuccess(true);
            response.setBody(accounts);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }
}

