/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpHandler;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;

public class PredicateHandler
implements SimpleHttpHandler {
    private final HttpHandler T;
    private final HttpHandler F;
    private final Predicate<SimpleHttpExchange> predicate;

    public PredicateHandler(Predicate<SimpleHttpExchange> predicate, HttpHandler handlerIfTrue, HttpHandler handlerIfFalse) {
        this.T = Objects.requireNonNull(handlerIfTrue);
        this.F = Objects.requireNonNull(handlerIfFalse);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        (this.predicate.test(exchange) ? this.T : this.F).handle(exchange);
    }

    public String toString() {
        return "PredicateHandler{T=" + this.T + ", F=" + this.F + ", predicate=" + this.predicate + '}';
    }
}

