/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Objects;

public class TemporaryHandler
implements HttpHandler {
    private final HttpHandler handler;
    private final Long expiry;

    public TemporaryHandler(HttpHandler handler) {
        this.handler = Objects.requireNonNull(handler);
        this.expiry = null;
    }

    public TemporaryHandler(HttpHandler handler, long maxTime) {
        this.handler = Objects.requireNonNull(handler);
        this.expiry = System.currentTimeMillis() + maxTime;
    }

    @Override
    public final synchronized void handle(HttpExchange exchange) throws IOException {
        if (this.expiry == null || System.currentTimeMillis() < this.expiry) {
            this.handler.handle(exchange);
        } else {
            exchange.sendResponseHeaders(404, 0L);
        }
        exchange.getHttpContext().getServer().removeContext(exchange.getHttpContext());
        exchange.close();
    }

    public String toString() {
        return "TemporaryHandler{handler=" + this.handler + ", expiry=" + this.expiry + '}';
    }
}

