/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.throttler;

import dev.katsute.simplehttpserver.HttpSession;
import dev.katsute.simplehttpserver.HttpSessionHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.handler.throttler.ConnectionThrottler;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionThrottler
extends ConnectionThrottler {
    private final HttpSessionHandler sessionHandler;
    private final Map<HttpSession, AtomicInteger> connections = new ConcurrentHashMap<HttpSession, AtomicInteger>();

    public SessionThrottler(HttpSessionHandler sessionHandler) {
        this.sessionHandler = Objects.requireNonNull(sessionHandler);
    }

    @Override
    final boolean addConnection(SimpleHttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        int maxConn = this.getMaxConnections(session, exchange);
        this.connections.putIfAbsent(session, new AtomicInteger(0));
        AtomicInteger conn = this.connections.get(session);
        if (maxConn < 0) {
            conn.incrementAndGet();
            return true;
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(SimpleHttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        if (this.connections.containsKey(session)) {
            this.connections.get(session).decrementAndGet();
        }
    }

    @Override
    public final int getMaxConnections(SimpleHttpExchange exchange) {
        return this.getMaxConnections(this.sessionHandler.getSession(exchange), exchange);
    }

    public int getMaxConnections(HttpSession session, SimpleHttpExchange exchange) {
        return -1;
    }

    public String toString() {
        return "SessionThrottler{sessionHandler=" + this.sessionHandler + ", connections=" + this.connections + '}';
    }
}

