/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.Query;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Consumer;
import lombok.NonNull;

public interface APIRequest {
    @NonNull
    public String getEndpoint();

    @NonNull
    public String getMethod();

    default public PathParameter[] getPathParameters() {
        return null;
    }

    default public Query[] getQueries() {
        return null;
    }

    default public void processHttpRequestBuilder(@NonNull HttpRequest.Builder httpRequestBuilder) {
        if (httpRequestBuilder == null) {
            throw new NullPointerException("httpRequestBuilder is marked non-null but is null");
        }
    }

    @NonNull
    default public HttpResponse.BodyHandler<?> getBodyHandler() {
        return HttpResponse.BodyHandlers.ofString();
    }

    default public String getContentType() {
        return null;
    }

    @NonNull
    default public HttpRequest.BodyPublisher getBodyPublisher() {
        return HttpRequest.BodyPublishers.noBody();
    }

    default public String getFinalEndpoint() {
        Object finalEndpoint = this.getEndpoint();
        if (this.getQueries() != null && this.getQueries().length != 0) {
            boolean first = true;
            for (Query query : this.getQueries()) {
                finalEndpoint = (String)finalEndpoint + (first ? "?" : "&") + query.toString();
                first = false;
            }
        }
        return finalEndpoint;
    }

    public static class Builder {
        private String endpoint;
        private String method;
        private String contentType;
        private PathParameter[] pathParameters;
        private Query[] queries;
        private Consumer<HttpRequest.Builder> httpRequestBuilderConsumer;
        private HttpRequest.BodyPublisher bodyPublisher;
        private HttpResponse.BodyHandler<?> bodyHandler;

        @NonNull
        public APIRequest build() {
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Endpoint cannot be null!");
            }
            if (this.method == null) {
                throw new IllegalArgumentException("Method cannot be null!");
            }
            return new APIRequest(){

                @Override
                public String getEndpoint() {
                    return endpoint;
                }

                @Override
                public String getMethod() {
                    return method;
                }

                @Override
                public String getContentType() {
                    if (contentType != null) {
                        return contentType;
                    }
                    return APIRequest.super.getContentType();
                }

                @Override
                public HttpRequest.BodyPublisher getBodyPublisher() {
                    if (bodyPublisher != null) {
                        return bodyPublisher;
                    }
                    return APIRequest.super.getBodyPublisher();
                }

                @Override
                public PathParameter[] getPathParameters() {
                    return pathParameters;
                }

                @Override
                public Query[] getQueries() {
                    return queries;
                }

                @Override
                public void processHttpRequestBuilder(HttpRequest.Builder httpRequestBuilder) {
                    if (httpRequestBuilderConsumer != null) {
                        httpRequestBuilderConsumer.accept(httpRequestBuilder);
                    } else {
                        APIRequest.super.processHttpRequestBuilder(httpRequestBuilder);
                    }
                }

                @Override
                public HttpResponse.BodyHandler<?> getBodyHandler() {
                    if (bodyHandler != null) {
                        return bodyHandler;
                    }
                    return APIRequest.super.getBodyHandler();
                }
            };
        }

        @NonNull
        public Builder setEndpoint(@NonNull String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint is marked non-null but is null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder setMethod(@NonNull String method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this;
        }

        public Builder setContentType(@NonNull String contentType) {
            if (contentType == null) {
                throw new NullPointerException("contentType is marked non-null but is null");
            }
            this.contentType = contentType;
            return this;
        }

        public Builder setBodyPublisher(@NonNull HttpRequest.BodyPublisher bodyPublisher) {
            if (bodyPublisher == null) {
                throw new NullPointerException("bodyPublisher is marked non-null but is null");
            }
            this.bodyPublisher = bodyPublisher;
            return this;
        }

        public Builder setPathParameters(PathParameter ... pathParameters) {
            if (pathParameters == null) {
                throw new NullPointerException("pathParameters is marked non-null but is null");
            }
            this.pathParameters = pathParameters;
            return this;
        }

        public Builder addPathParameter(@NonNull PathParameter pathParameter) {
            if (pathParameter == null) {
                throw new NullPointerException("pathParameter is marked non-null but is null");
            }
            if (this.pathParameters == null || this.pathParameters.length == 0) {
                this.pathParameters = new PathParameter[1];
                this.pathParameters[0] = pathParameter;
                return this;
            }
            PathParameter[] newPathParameters = new PathParameter[this.pathParameters.length + 1];
            System.arraycopy(this.pathParameters, 0, newPathParameters, 0, this.pathParameters.length);
            newPathParameters[newPathParameters.length - 1] = pathParameter;
            this.pathParameters = newPathParameters;
            return this;
        }

        public Builder setQueries(Query ... queries) {
            if (queries == null) {
                throw new NullPointerException("queries is marked non-null but is null");
            }
            this.queries = queries;
            return this;
        }

        public Builder addQuery(@NonNull Query query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            if (this.queries == null || this.queries.length == 0) {
                this.queries = new Query[1];
                this.queries[0] = query;
                return this;
            }
            Query[] newQueries = new Query[this.queries.length + 1];
            System.arraycopy(this.queries, 0, newQueries, 0, this.queries.length);
            newQueries[newQueries.length - 1] = query;
            this.queries = newQueries;
            return this;
        }

        public Builder setHttpRequestBuilder(@NonNull Consumer<HttpRequest.Builder> httpRequestBuilderConsumer) {
            if (httpRequestBuilderConsumer == null) {
                throw new NullPointerException("httpRequestBuilderConsumer is marked non-null but is null");
            }
            this.httpRequestBuilderConsumer = httpRequestBuilderConsumer;
            return this;
        }

        public Builder setBodyHandler(@NonNull HttpResponse.BodyHandler<?> bodyHandler) {
            if (bodyHandler == null) {
                throw new NullPointerException("bodyHandler is marked non-null but is null");
            }
            this.bodyHandler = bodyHandler;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getMethod() {
            return this.method;
        }

        public String getContentType() {
            return this.contentType;
        }

        public PathParameter[] getPathParameters() {
            return this.pathParameters;
        }

        public Query[] getQueries() {
            return this.queries;
        }

        public Consumer<HttpRequest.Builder> getHttpRequestBuilderConsumer() {
            return this.httpRequestBuilderConsumer;
        }

        public HttpRequest.BodyPublisher getBodyPublisher() {
            return this.bodyPublisher;
        }

        public HttpResponse.BodyHandler<?> getBodyHandler() {
            return this.bodyHandler;
        }
    }
}

