/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.ApiRequestBuilder;
import dev.mayuna.simpleapi.ApiResponse;
import dev.mayuna.simpleapi.DeserializableApiResponse;
import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.RequestHeader;
import dev.mayuna.simpleapi.RequestMethod;
import dev.mayuna.simpleapi.RequestQuery;
import dev.mayuna.simpleapi.WrappedApi;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ApiRequest<T> {
    public static <T> ApiRequestBuilder<T> builder(WrappedApi wrappedApi, Class<T> responseClass) {
        return ApiRequestBuilder.ofResponse(wrappedApi, responseClass);
    }

    @NotNull
    public WrappedApi getWrappedApi();

    @NotNull
    public Class<T> getResponseClass();

    @Nullable
    public String getUrl();

    @NotNull
    public String getEndpoint();

    @NotNull
    public RequestMethod getRequestMethod();

    @Nullable
    default public PathParameter[] getPathParameters() {
        return null;
    }

    @Nullable
    default public RequestQuery[] getRequestQueries() {
        return null;
    }

    @Nullable
    default public RequestHeader[] getRequestHeaders() {
        return null;
    }

    @NonNull
    default public HttpRequest.BodyPublisher getBodyPublisher() {
        return HttpRequest.BodyPublishers.noBody();
    }

    @NotNull
    default public HttpResponse.BodyHandler<?> getBodyHandler() {
        return HttpResponse.BodyHandlers.ofString();
    }

    default public String getComputedEndpoint() {
        RequestQuery[] requestQueries;
        Object computedEndpoint = this.getEndpoint();
        PathParameter[] pathParameters = this.getPathParameters();
        if (pathParameters != null && pathParameters.length > 0) {
            for (PathParameter pathParameter : this.getPathParameters()) {
                computedEndpoint = ((String)computedEndpoint).replace("{" + pathParameter.getId() + "}", pathParameter.getReplacement());
            }
        }
        if ((requestQueries = this.getRequestQueries()) != null && requestQueries.length > 0) {
            for (int i = 0; i < requestQueries.length; ++i) {
                RequestQuery requestQuery = requestQueries[i];
                String querySymbol = "&";
                if (i == 0) {
                    querySymbol = "?";
                }
                computedEndpoint = (String)computedEndpoint + querySymbol + requestQuery.getName() + "=" + requestQuery.getValue();
            }
        }
        return computedEndpoint;
    }

    default public void applyHeadersToHttpRequestBuilder(HttpRequest.Builder httpRequestBuilder, RequestHeader[] requestHeaders) {
        if (requestHeaders != null) {
            for (RequestHeader requestHeader : requestHeaders) {
                httpRequestBuilder.header(requestHeader.getKey(), requestHeader.getValue());
            }
        }
    }

    default public HttpClient createHttpClientInstance() {
        return HttpClient.newBuilder().build();
    }

    default public HttpRequest.Builder createHttpRequestBuilderInstance() {
        return HttpRequest.newBuilder();
    }

    default public T createInstanceOfResponseClass() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.getResponseClass().isArray()) {
            throw new RuntimeException("Cannot create instance of array");
        }
        return this.getResponseClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    default public T handleResponse(HttpResponse<?> httpResponse) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object responseInstance = this.createInstanceOfResponseClass();
        if (responseInstance instanceof ApiResponse) {
            ApiResponse apiResponse = (ApiResponse)responseInstance;
            apiResponse.setHttpStatusCode(httpResponse.statusCode());
            apiResponse.setWrappedApi(this.getWrappedApi());
        }
        if (responseInstance instanceof DeserializableApiResponse) {
            responseInstance = ((DeserializableApiResponse)responseInstance).deserialize(httpResponse.body());
        }
        return responseInstance;
    }

    default public ThreadFactory getThreadFactory() {
        return Thread::new;
    }

    default public CompletableFuture<T> sendAsync() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.getThreadFactory().newThread(() -> {
            try {
                completableFuture.complete(this.send());
            }
            catch (Exception exception) {
                completableFuture.completeExceptionally(exception);
            }
        }).start();
        return completableFuture;
    }

    default public T send() throws IOException, InterruptedException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        String url = this.getUrl();
        if (url == null) {
            url = this.getWrappedApi().getDefaultUrl();
        }
        String requestUrl = url + this.getComputedEndpoint();
        HttpClient httpClient = this.createHttpClientInstance();
        HttpRequest.Builder httpRequestBuilder = this.createHttpRequestBuilderInstance();
        try {
            httpRequestBuilder.uri(new URI(requestUrl));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new RuntimeException("Invalid URI " + requestUrl, e);
        }
        this.applyHeadersToHttpRequestBuilder(httpRequestBuilder, this.getRequestHeaders());
        httpRequestBuilder.method(this.getRequestMethod().getName(), this.getBodyPublisher());
        this.getWrappedApi().onApiRequest(this);
        HttpResponse<?> httpResponse = httpClient.send(httpRequestBuilder.build(), this.getBodyHandler());
        return this.handleResponse(httpResponse);
    }
}

