/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public abstract class AbstractParentCommand
implements ICommand {
    @NonNull
    private final Map<String, ICommand> commandToSubcommandHandlerMap = Collections.synchronizedMap(new LinkedHashMap());
    private final boolean subCommandRequired;

    protected AbstractParentCommand(boolean subCommandRequired) {
        this.subCommandRequired = subCommandRequired;
    }

    protected final void addCommandHandler(ICommand handler) {
        String commandName = handler.getName();
        this.commandToSubcommandHandlerMap.put(commandName, handler);
    }

    @Override
    public ICommand getSubCommandByName(String name) {
        return this.commandToSubcommandHandlerMap.get(name);
    }

    @Override
    public Collection<ICommand> getSubCommands() {
        return Collections.unmodifiableCollection(this.commandToSubcommandHandlerMap.values());
    }

    @Override
    public boolean isSubCommandRequired() {
        return this.subCommandRequired;
    }

    @Override
    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using(callingContext, cmdLine, this::executeCommand);
    }

    @NonNull
    protected ExitStatus executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine commandLine) {
        callingContext.showHelp();
        ExitStatus status = this.isSubCommandRequired() ? ExitCode.INVALID_COMMAND.exitMessage("Please use one of the following sub-commands: " + this.getSubCommands().stream().map(ICommand::getName).collect(Collectors.joining(", "))) : ExitCode.OK.exit();
        return status;
    }
}

