/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.AbstractExitStatus;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MessageExitStatus
extends AbstractExitStatus {
    private final List<Object> messageArguments;

    public MessageExitStatus(@NonNull ExitCode code, Object ... messageArguments) {
        super(code);
        this.messageArguments = messageArguments.length == 0 ? Collections.emptyList() : Arrays.asList(messageArguments);
    }

    @Override
    public String getMessage() {
        String format = this.lookupMessageForCode(this.getExitCode());
        return String.format(format, this.messageArguments.toArray());
    }

    private String lookupMessageForCode(ExitCode ignoredExitCode) {
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index <= this.messageArguments.size(); ++index) {
            if (index > 1) {
                builder.append(' ');
            }
            builder.append("%s");
        }
        return builder.toString();
    }
}

