/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;

public class StringUtils {
    public static String padLeft(String string, int totalLength) {
        return String.format("%-" + totalLength + "s", string);
    }

    public static String padRight(String string, int totalLength) {
        return String.format("%" + totalLength + "s", string);
    }

    public static String decodeURL(String encoded) {
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static String applySha256(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileData(File file, int fileLength) throws IOException {
        byte[] fileData = new byte[fileLength];
        try (FileInputStream fileIn = null;){
            fileIn = new FileInputStream(file);
            fileIn.read(fileData);
        }
        return fileData;
    }

    public static boolean saveToFile(Path file, String data) {
        try {
            FileOutputStream fos = new FileOutputStream(file.toFile().getAbsolutePath());
            fos.write(data.getBytes());
            fos.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static HashMap<String, String> stringToMap(String input) {
        String[] nameValuePairs;
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String nameValuePair : nameValuePairs = input.split("&")) {
            String[] nameValue = nameValuePair.split("=");
            try {
                map.put(URLDecoder.decode(nameValue[0], "UTF-8"), nameValue.length > 1 ? URLDecoder.decode(nameValue[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This method requires UTF-8 encoding support", e);
            }
        }
        return map;
    }

    public static byte[] chunkInsert(String data, int n, char insert) {
        if (data == null) {
            throw new IllegalArgumentException("input String is null");
        }
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (int i = 0; i < data.length(); ++i) {
            byteList.add((byte)data.charAt(i));
            if ((i + 1) % n != 0) continue;
            byteList.add((byte)insert);
        }
        byte[] result = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            result[i] = (Byte)byteList.get(i);
        }
        return result;
    }

    public static String[] splitStringEvery(String s, int interval) {
        if (s == null) {
            throw new IllegalArgumentException("input string is null");
        }
        if (interval < 0) {
            throw new IllegalArgumentException("interval must be greater or equal to 0");
        }
        int arrayLength = (int)Math.ceil((double)s.length() / (double)interval);
        String[] result = new String[arrayLength];
        int j = 0;
        int lastIndex = result.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            result[i] = s.substring(j, j + interval);
            j += interval;
        }
        result[lastIndex] = s.substring(j);
        return result;
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder string = new StringBuilder();
        for (byte b : bytes) {
            String hexString = Integer.toHexString(0xFF & b);
            string.append((String)(hexString.length() == 1 ? "0" + hexString : hexString));
        }
        return string.toString();
    }

    public static byte[] hexStringToByteArray(String string) {
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return data;
    }

    public static String hexToString(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }
}

