/*
 * Decompiled with CFR 0.152.
 */
package co.statu.rule.database;

import co.statu.parsek.api.ParsekPlugin;
import co.statu.parsek.api.config.PluginConfigManager;
import co.statu.rule.database.Dao;
import co.statu.rule.database.DatabaseConfig;
import co.statu.rule.database.DatabaseManager;
import co.statu.rule.database.DatabaseMigration;
import co.statu.rule.database.DatabasePlugin;
import co.statu.rule.database.api.DatabaseHelper;
import co.statu.rule.database.impl.SchemeVersionDaoImpl;
import co.statu.rule.database.model.SchemeVersion;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.jdbcclient.JDBCPool;
import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0012J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010%J\"\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0086@\u00a2\u0006\u0002\u0010*J&\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010.J\u0017\u0010/\u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b0J(\u00101\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\b\u00102\u001a\u0004\u0018\u000103H\u0086@\u00a2\u0006\u0002\u00104J.\u00105\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u00109J&\u0010:\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010;\u001a\u000207H\u0082@\u00a2\u0006\u0002\u0010<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lco/statu/rule/database/DatabaseManager;", "", "vertx", "Lio/vertx/core/Vertx;", "logger", "Lorg/slf4j/Logger;", "databasePlugin", "Lco/statu/rule/database/DatabasePlugin;", "<init>", "(Lio/vertx/core/Vertx;Lorg/slf4j/Logger;Lco/statu/rule/database/DatabasePlugin;)V", "pluginConfigManager", "Lco/statu/parsek/api/config/PluginConfigManager;", "Lco/statu/rule/database/DatabaseConfig;", "getPluginConfigManager", "()Lco/statu/parsek/api/config/PluginConfigManager;", "pluginConfigManager$delegate", "Lkotlin/Lazy;", "pool", "Lio/vertx/jdbcclient/JDBCPool;", "tables", "", "Lco/statu/parsek/api/ParsekPlugin;", "", "Lco/statu/rule/database/Dao;", "migrations", "Lco/statu/rule/database/DatabaseMigration;", "schemeVersionDaoImpl", "Lco/statu/rule/database/impl/SchemeVersionDaoImpl;", "getTablePrefix", "", "getConnectionPool", "initTables", "", "plugin", "(Lco/statu/parsek/api/ParsekPlugin;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initSchemeVersion", "jdbcPool", "(Lco/statu/parsek/api/ParsekPlugin;Lio/vertx/jdbcclient/JDBCPool;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initPluginDB", "initialize", "databaseHelper", "Lco/statu/rule/database/api/DatabaseHelper;", "(Lco/statu/parsek/api/ParsekPlugin;Lco/statu/rule/database/api/DatabaseHelper;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "migrateNewPluginId", "exPluginId", "newPluginId", "(Ljava/lang/String;Ljava/lang/String;Lco/statu/parsek/api/ParsekPlugin;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLatestMigration", "getLatestMigration$parsek_plugin_database", "checkMigration", "lastSchemeVersion", "Lco/statu/rule/database/model/SchemeVersion;", "(Lco/statu/parsek/api/ParsekPlugin;Lio/vertx/jdbcclient/JDBCPool;Lco/statu/rule/database/model/SchemeVersion;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateSchemeVersion", "version", "", "info", "(ILjava/lang/String;Lco/statu/parsek/api/ParsekPlugin;Lio/vertx/jdbcclient/JDBCPool;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "migrate", "databaseVersion", "(Lco/statu/parsek/api/ParsekPlugin;Lio/vertx/jdbcclient/JDBCPool;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parsek-plugin-database"})
@SourceDebugExtension(value={"SMAP\nDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseManager.kt\nco/statu/rule/database/DatabaseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1863#2,2:239\n1971#2,14:242\n1#3:241\n*S KotlinDebug\n*F\n+ 1 DatabaseManager.kt\nco/statu/rule/database/DatabaseManager\n*L\n73#1:239,2\n190#1:242,14\n*E\n"})
public final class DatabaseManager {
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DatabasePlugin databasePlugin;
    @NotNull
    private final Lazy pluginConfigManager$delegate;
    private JDBCPool pool;
    @NotNull
    private final Map<ParsekPlugin, List<Dao<?>>> tables;
    @NotNull
    private final Map<ParsekPlugin, List<DatabaseMigration>> migrations;
    @NotNull
    private final SchemeVersionDaoImpl schemeVersionDaoImpl;

    public DatabaseManager(@NotNull Vertx vertx, @NotNull Logger logger, @NotNull DatabasePlugin databasePlugin) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)databasePlugin), (String)"databasePlugin");
        this.vertx = vertx;
        this.logger = logger;
        this.databasePlugin = databasePlugin;
        this.pluginConfigManager$delegate = LazyKt.lazy(() -> DatabaseManager.pluginConfigManager_delegate$lambda$0(this));
        this.tables = new LinkedHashMap();
        this.migrations = new LinkedHashMap();
        this.schemeVersionDaoImpl = new SchemeVersionDaoImpl();
    }

    private final PluginConfigManager<DatabaseConfig> getPluginConfigManager() {
        Lazy lazy = this.pluginConfigManager$delegate;
        return (PluginConfigManager)lazy.getValue();
    }

    @NotNull
    public final String getTablePrefix() {
        return ((DatabaseConfig)this.getPluginConfigManager().getConfig()).getPrefix();
    }

    @NotNull
    public final JDBCPool getConnectionPool() {
        if (this.pool == null) {
            DatabaseConfig databaseConfig = (DatabaseConfig)this.getPluginConfigManager().getConfig();
            String host = databaseConfig.getHost();
            String name = databaseConfig.getName();
            String username = databaseConfig.getUsername();
            String password = databaseConfig.getPassword();
            JsonObject jsonObject = new JsonObject().put("url", (Object)("jdbc:clickhouse:" + host + '/' + name)).put("driver_class", (Object)"com.clickhouse.jdbc.ClickHouseDriver").put("datasourceName", (Object)"parsek").put("username", (Object)username).put("max_pool_size", (Object)100);
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"put(...)");
            JsonObject config = jsonObject;
            if (!Intrinsics.areEqual((Object)password, (Object)"")) {
                config.put("password", (Object)password);
            }
            this.pool = JDBCPool.pool((Vertx)this.vertx, (JsonObject)config);
        }
        try {
            JDBCPool jDBCPool = this.pool;
            if (jDBCPool == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
                jDBCPool = null;
            }
            return jDBCPool;
        }
        catch (Exception e) {
            this.logger.error("Failed to connect database! Please check your configuration! Error is: " + e);
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object initTables(ParsekPlugin var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof initTables.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseManager.access$initTables(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    v0 = this.tables.get(plugin);
                    if (v0 == null) return Unit.INSTANCE;
                    $this$forEach$iv = v0;
                    $i$f$forEach = false;
                    var5_9 = $this$forEach$iv.iterator();
                }
                catch (Exception e) {
                    this.logger.error(e.toString());
                    throw e;
                }
lbl23:
                // 2 sources

                while (true) {
                    if (var5_9.hasNext() == false) return Unit.INSTANCE;
                    element$iv = var5_9.next();
                    it = (Dao)element$iv;
                    $i$a$-forEach-DatabaseManager$initTables$2 = false;
                    v1 = this.pool;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
                        v1 = null;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = plugin;
                    $continuation.L$2 = var5_9;
                    $continuation.label = 1;
                    v2 = it.init(v1, plugin, (Continuation<Unit>)$continuation);
                    if (v2 != var11_5) continue;
                    return var11_5;
                }
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-DatabaseManager$initTables$2 = false;
                var5_9 = (Iterator<T>)$continuation.L$2;
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object initSchemeVersion(ParsekPlugin var1_1, JDBCPool var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof initSchemeVersion.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseManager.access$initSchemeVersion(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.L$2 = jdbcPool;
                $continuation.label = 1;
                v0 = this.schemeVersionDaoImpl.getLastSchemeVersion(plugin.getPluginId(), jdbcPool, (Continuation<? super SchemeVersion>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                jdbcPool = (JDBCPool)$continuation.L$2;
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                lastSchemeVersion = (SchemeVersion)v0;
                latestMigration = this.getLatestMigration$parsek_plugin_database(plugin);
                if (lastSchemeVersion != null) {
                    return Unit.INSTANCE;
                }
                if (latestMigration != null) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = this.schemeVersionDaoImpl.add(new SchemeVersion(plugin.getPluginId(), null, 1, "Init " + plugin.getPluginId(), 2, null), jdbcPool, (Continuation<? super Unit>)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl42
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 3;
        v2 = this.schemeVersionDaoImpl.add(new SchemeVersion(plugin.getPluginId(), null, latestMigration.getSCHEME_VERSION(), latestMigration.getSCHEME_VERSION_INFO(), 2, null), jdbcPool, (Continuation<? super Unit>)$continuation);
        if (v2 == var8_6) {
            return var8_6;
        }
        ** GOTO lbl54
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl54:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object initPluginDB(ParsekPlugin var1_1, JDBCPool var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof initPluginDB.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseManager.access$initPluginDB(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.label = 1;
                v0 = this.initSchemeVersion(plugin, (JDBCPool)jdbcPool, (Continuation<? super Unit>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.label = 2;
                v1 = this.initTables(plugin, (Continuation<? super Unit>)$continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl36
            }
            case 2: {
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                this.logger.info('\"' + plugin.getPluginId() + "\"'s database has been initialized");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object initialize(@NotNull ParsekPlugin var1_1, @Nullable DatabaseHelper var2_2, @NotNull Continuation<? super Unit> $completion) {
        block28: {
            if (!($completion instanceof initialize.1)) ** GOTO lbl-1000
            var10_4 = $completion;
            if ((var10_4.label & -2147483648) != 0) {
                var10_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ DatabaseManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.initialize(null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.tables.get(plugin) == null) {
                        this.tables.put(plugin, (List)new ArrayList<E>());
                    }
                    if (this.migrations.get(plugin) == null) {
                        this.migrations.put(plugin, (List<DatabaseMigration>)new ArrayList<E>());
                    }
                    if ((v0 = databaseHelper) != null && (v0 = v0.getTables()) != null) {
                        it /* !! */  = v0;
                        $i$a$-let-DatabaseManager$initialize$2 = false;
                        v1 = this.tables.get(plugin);
                        Intrinsics.checkNotNull(v1);
                        Boxing.boxBoolean((boolean)v1.addAll((Collection)it /* !! */ ));
                    }
                    if ((v2 = databaseHelper) != null && (v2 = v2.getMigrations()) != null) {
                        it /* !! */  = v2;
                        $i$a$-let-DatabaseManager$initialize$3 = false;
                        v3 = this.migrations.get(plugin);
                        Intrinsics.checkNotNull(v3);
                        Boxing.boxBoolean((boolean)v3.addAll((Collection<DatabaseMigration>)it /* !! */ ));
                    }
                    try {
                        jdbcPool = this.getConnectionPool();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.info("Connection to database failed! Shutting down...");
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = plugin;
                    $continuation.L$2 = jdbcPool;
                    $continuation.label = 1;
                    v4 = this.schemeVersionDaoImpl.getLastSchemeVersion(plugin.getPluginId(), jdbcPool, (Continuation<? super SchemeVersion>)$continuation);
                    ** if (v4 != var11_6) goto lbl54
lbl53:
                    // 1 sources

                    return var11_6;
lbl54:
                    // 1 sources

                    ** GOTO lbl63
                }
                case 1: {
                    jdbcPool = (JDBCPool)$continuation.L$2;
                    plugin = (ParsekPlugin)$continuation.L$1;
                    this = (DatabaseManager)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl63:
                        // 2 sources

                        lastSchemeVersion = (SchemeVersion)v4;
                        break;
                    }
                    catch (BatchUpdateException var6_8) {
                        if (!(plugin instanceof DatabasePlugin)) ** GOTO lbl86
                        this.logger.warn("First time installing scheme version (first time app installation)");
                        $continuation.L$0 = this;
                        $continuation.L$1 = plugin;
                        $continuation.L$2 = jdbcPool;
                        $continuation.label = 2;
                        v5 = this.schemeVersionDaoImpl.init(jdbcPool, plugin, (Continuation<? super Unit>)$continuation);
                        ** if (v5 != var11_6) goto lbl77
lbl76:
                        // 1 sources

                        return var11_6;
lbl77:
                        // 1 sources

                        ** GOTO lbl86
                    }
                }
                case 2: {
                    jdbcPool = (JDBCPool)$continuation.L$2;
                    plugin = (ParsekPlugin)$continuation.L$1;
                    this = (DatabaseManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl86:
                    // 3 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = plugin;
                    $continuation.L$2 = null;
                    $continuation.label = 3;
                    v6 = this.initPluginDB(plugin, jdbcPool, (Continuation<? super Unit>)$continuation);
                    ** if (v6 != var11_6) goto lbl93
lbl92:
                    // 1 sources

                    return var11_6;
lbl93:
                    // 1 sources

                    ** GOTO lbl101
                }
                case 3: {
                    plugin = (ParsekPlugin)$continuation.L$1;
                    this = (DatabaseManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl101:
                    // 2 sources

                    return Unit.INSTANCE;
                    {
                        catch (Exception e) {
                            this.logger.error(e.getMessage());
                            this.logger.error("Database Error: Could not install plugin \"" + plugin.getPluginId() + "\". Shutting down...");
                            System.exit(1);
                            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                        }
                    }
                }
            }
            if (lastSchemeVersion != null) break block28;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.L$2 = null;
            $continuation.label = 4;
            v7 = this.initPluginDB(plugin, jdbcPool, (Continuation<? super Unit>)$continuation);
            if (v7 == var11_6) {
                return var11_6;
            }
            ** GOTO lbl119
            {
                case 4: {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl119:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
        }
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 5;
        v8 = this.checkMigration(plugin, jdbcPool, lastSchemeVersion, (Continuation<? super Unit>)$continuation);
        if (v8 == var11_6) {
            return var11_6;
        }
        ** GOTO lbl132
        {
            case 5: {
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl132:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object initialize$default(DatabaseManager databaseManager, ParsekPlugin parsekPlugin, DatabaseHelper databaseHelper, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            databaseHelper = null;
        }
        return databaseManager.initialize(parsekPlugin, databaseHelper, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object migrateNewPluginId(@NotNull String var1_1, @NotNull String var2_2, @NotNull ParsekPlugin var3_3, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof migrateNewPluginId.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.migrateNewPluginId(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.label = 1;
                v0 = this.schemeVersionDaoImpl.renamePluginId((String)exPluginId, (String)newPluginId, this.getConnectionPool(), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var8_7) goto lbl20
lbl19:
                // 1 sources

                return var8_7;
lbl20:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    if (plugin instanceof DatabasePlugin) ** GOTO lbl34
                    this.logger.error(e.getMessage());
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
lbl34:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final DatabaseMigration getLatestMigration$parsek_plugin_database(@NotNull ParsekPlugin plugin) {
        DatabaseMigration databaseMigration;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        List<DatabaseMigration> list = this.migrations.get(plugin);
        if (list != null) {
            Object v1;
            Iterable $this$maxByOrNull$iv = list;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    DatabaseMigration it = (DatabaseMigration)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getSCHEME_VERSION();
                    do {
                        Object e$iv = iterator$iv.next();
                        DatabaseMigration it2 = (DatabaseMigration)e$iv;
                        $i$a$-maxByOrNull-DatabaseManager$getLatestMigration$1 = false;
                        int v$iv = it2.getSCHEME_VERSION();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            databaseMigration = v1;
        } else {
            databaseMigration = null;
        }
        return databaseMigration;
    }

    @Nullable
    public final Object checkMigration(@NotNull ParsekPlugin plugin, @NotNull JDBCPool jdbcPool, @Nullable SchemeVersion lastSchemeVersion, @NotNull Continuation<? super Unit> $completion) {
        int databaseVersion;
        this.logger.info("Checking available database migrations for \"" + plugin.getPluginId() + '\"');
        SchemeVersion schemeVersion = lastSchemeVersion;
        int n = databaseVersion = schemeVersion != null ? schemeVersion.getVersion() : 0;
        if (databaseVersion == 0) {
            this.logger.error("Database Error: Database scheme is not correct, please reinstall platform");
            return Unit.INSTANCE;
        }
        Object object = this.migrate(plugin, jdbcPool, databaseVersion, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object updateSchemeVersion(int version, String info, ParsekPlugin plugin, JDBCPool jdbcPool, Continuation<? super Unit> $completion) {
        Object object = this.schemeVersionDaoImpl.add(new SchemeVersion(plugin.getPluginId(), null, version, info, 2, null), jdbcPool, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object migrate(ParsekPlugin var1_1, JDBCPool var2_2, int var3_3, Continuation<? super Unit> $completion) {
        if (!($completion instanceof migrate.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseManager.access$migrate(this.this$0, null, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.migrations.get(plugin);
                Intrinsics.checkNotNull(v0);
                var6_8 = v0;
                for (T var8_14 : var6_8) {
                    it = (DatabaseMigration)var8_14;
                    $i$a$-find-DatabaseManager$migrate$2 = false;
                    if (!it.isMigratable((int)databaseVersion)) continue;
                    v1 = var8_14;
                    ** GOTO lbl22
                }
                v1 = null;
lbl22:
                // 2 sources

                var5_18 = v1;
                if (var5_18 == null) break;
                it = var5_18;
                $i$a$-let-DatabaseManager$migrate$3 = false;
                this.logger.info("Migration Found! Migrating database from version " + it.getFROM_SCHEME_VERSION() + " to " + it.getSCHEME_VERSION() + ": " + it.getSCHEME_VERSION_INFO());
                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.L$2 = jdbcPool;
                $continuation.L$3 = it;
                $continuation.label = 1;
                v2 = it.migrate(jdbcPool, this.getTablePrefix(), (Continuation<? super Unit>)$continuation);
                ** if (v2 != var13_7) goto lbl37
lbl36:
                // 1 sources

                return var13_7;
lbl37:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$a$-let-DatabaseManager$migrate$3 = false;
                it = (DatabaseMigration)$continuation.L$3;
                jdbcPool = (JDBCPool)$continuation.L$2;
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl48:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = plugin;
                $continuation.L$2 = jdbcPool;
                $continuation.L$3 = it;
                $continuation.label = 2;
                v3 = this.updateSchemeVersion(it.getSCHEME_VERSION(), it.getSCHEME_VERSION_INFO(), plugin, jdbcPool, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var13_7) goto lbl56
lbl55:
                // 1 sources

                return var13_7;
lbl56:
                // 1 sources

                ** GOTO lbl73
            }
            case 2: {
                $i$a$-let-DatabaseManager$migrate$3 = false;
                it = (DatabaseMigration)$continuation.L$3;
                jdbcPool = (JDBCPool)$continuation.L$2;
                plugin = (ParsekPlugin)$continuation.L$1;
                this = (DatabaseManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Exception e) {
                    this.logger.error("Database Error: Migration failed from version " + it.getFROM_SCHEME_VERSION() + " to " + it.getSCHEME_VERSION() + ", error: " + e);
                    this.logger.error("Shutting down...");
                    System.exit(1);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
lbl73:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 3;
                v4 = this.migrate(plugin, jdbcPool, it.getSCHEME_VERSION(), (Continuation<? super Unit>)$continuation);
                if (v4 == var13_7) {
                    return var13_7;
                }
                break;
            }
            case 3: {
                $i$a$-let-DatabaseManager$migrate$3 = false;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final PluginConfigManager pluginConfigManager_delegate$lambda$0(DatabaseManager this$0) {
        Object object = this$0.databasePlugin.getPluginBeanContext().getBean(PluginConfigManager.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type co.statu.parsek.api.config.PluginConfigManager<co.statu.rule.database.DatabaseConfig>");
        return (PluginConfigManager)object;
    }

    public static final /* synthetic */ Object access$initTables(DatabaseManager $this, ParsekPlugin plugin, Continuation $completion) {
        return $this.initTables(plugin, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$initSchemeVersion(DatabaseManager $this, ParsekPlugin plugin, JDBCPool jdbcPool, Continuation $completion) {
        return $this.initSchemeVersion(plugin, jdbcPool, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$initPluginDB(DatabaseManager $this, ParsekPlugin plugin, JDBCPool jdbcPool, Continuation $completion) {
        return $this.initPluginDB(plugin, jdbcPool, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateSchemeVersion(DatabaseManager $this, int version, String info, ParsekPlugin plugin, JDBCPool jdbcPool, Continuation $completion) {
        return $this.updateSchemeVersion(version, info, plugin, jdbcPool, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$migrate(DatabaseManager $this, ParsekPlugin plugin, JDBCPool jdbcPool, int databaseVersion, Continuation $completion) {
        return $this.migrate(plugin, jdbcPool, databaseVersion, (Continuation<? super Unit>)$completion);
    }
}

