/*
 * Decompiled with CFR 0.152.
 */
package dev.rafex.ether.cli;

import dev.rafex.ether.cli.ICliDefault;
import dev.rafex.ether.cli.ValuesCli;
import dev.rafex.ether.properties.Properties;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.lang3.math.NumberUtils;

public final class CliDefault
implements ICliDefault {
    private final Logger LOGGER = Logger.getLogger(CliDefault.class.getName());
    private static CliDefault instance;
    protected String[] args = null;
    protected final Options options = new Options();
    protected final CommandLineParser parser = new DefaultParser();
    protected final Map<String, Object> optionsMap = new HashMap<String, Object>();

    private CliDefault(String[] args) {
        this.args = args;
        this.options.addOption("h", "help", false, "show help.");
        this.options.addOption("v", "version", false, "shows the version.");
        this.options.addOption("p", "properties", true, "select properties.");
        this.options.addOption("H", "host", true, "select IP host.");
        this.options.addOption("P", "port", true, "select port.");
        this.options.addOption("t", "minThreads", true, "min Threads.");
        this.options.addOption("T", "maxThreads", true, "max Threads.");
        this.arguments(this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CliDefault getInstance(String[] args) {
        if (instance != null) return instance;
        Class<CliDefault> clazz = CliDefault.class;
        synchronized (CliDefault.class) {
            if (instance != null) return instance;
            instance = new CliDefault(args);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ValuesCli parse() {
        CommandLine cmd = null;
        try {
            ValuesCli valuesCli = new ValuesCli();
            cmd = this.parser.parse(this.options, this.args);
            if (cmd.hasOption("h")) {
                this.help();
            }
            if (cmd.hasOption("v")) {
                System.out.println("Version: " + Properties.getProperty((String)"app.version"));
                this.help();
            }
            if (cmd.hasOption("p")) {
                Properties.loadProperties((String)cmd.getOptionValue("p"));
            }
            if (cmd.hasOption("P")) {
                valuesCli.setPort(NumberUtils.toInt((String)cmd.getOptionValue("P", "8080")));
            }
            if (cmd.hasOption("t")) {
                valuesCli.setPort(NumberUtils.toInt((String)cmd.getOptionValue("t", "200")));
            }
            if (cmd.hasOption("T")) {
                valuesCli.setPort(NumberUtils.toInt((String)cmd.getOptionValue("T", "50")));
            }
            if (cmd.hasOption("o")) {
                valuesCli.setPort(NumberUtils.toInt((String)cmd.getOptionValue("o", "3000")));
            }
            if (cmd.hasOption("H")) {
                valuesCli.setHost(cmd.getOptionValue("H", "0.0.0.0"));
            }
            return valuesCli;
        }
        catch (UnrecognizedOptionException ex) {
            this.LOGGER.severe("Failed ");
        }
        catch (ParseException ex) {
            this.LOGGER.info("Failed to parse comand line properties");
            this.help();
        }
        return null;
    }

    protected void help() {
        HelpFormatter formater = new HelpFormatter();
        formater.printHelp("Main", this.options);
        System.exit(0);
    }

    private void arguments(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.LOGGER.info("Argument: [" + i + "][" + args[i] + "]");
            }
        }
    }
}

