/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry;

import java.io.Serializable;
import java.util.Objects;

public class Vertex2D
implements Serializable {
    public float x;
    public float y;

    public Vertex2D(float x, float y) {
        this.x = Float.isFinite(x) ? x : 0.0f;
        this.y = Float.isFinite(y) ? y : 0.0f;
    }

    public Vertex2D scale(float factor) {
        this.x *= factor;
        this.y += factor;
        return this;
    }

    public Vertex2D translateX(float translate) {
        this.x += translate;
        return this;
    }

    public Vertex2D translateY(float translate) {
        this.y += translate;
        return this;
    }

    public Vertex2D rotateY(float rotY) {
        float newX;
        double rotYRad = Math.toRadians(rotY);
        this.x = newX = (float)((double)this.x * Math.cos(rotYRad) - Math.sin(rotYRad));
        return this;
    }

    public Vertex2D rotateX(float rotX) {
        float newY;
        double rotXRad = Math.toRadians(rotX);
        this.y = newY = (float)(Math.sin(rotXRad) + (double)this.y * Math.cos(rotXRad));
        return this;
    }

    public double[][] toMatrix() {
        return new double[][]{{this.x, 1.0}, {1.0, this.y}};
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vertex2D rotateZ(int rotZ) {
        double rotZRad = Math.toRadians(rotZ);
        float newX = (float)((double)this.x * Math.cos(rotZRad) - (double)this.y * Math.sin(rotZRad));
        float newY = (float)((double)this.x * Math.sin(rotZRad) + (double)this.y * Math.cos(rotZRad));
        this.x = newX;
        this.y = newY;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex2D vertex2D = (Vertex2D)o;
        return Float.compare(vertex2D.x, this.x) == 0 && Float.compare(vertex2D.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return "Vertex2D{x=" + this.x + ", y=" + this.y + "}";
    }
}

