/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry;

import dev.secondsun.util.Plane;
import java.util.Objects;

public class Vertex {
    public static final Vertex ZERO = new Vertex(0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;

    public Vertex(Vertex toCopy) {
        this.x = toCopy.x;
        this.y = toCopy.y;
        this.z = toCopy.z;
    }

    public Vertex(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vertex scale(float factor) {
        Vertex v1 = new Vertex(this.x * factor, this.y * factor, this.z * factor);
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
        return this;
    }

    public Vertex translateX(float translate) {
        Vertex v1 = new Vertex(this.x + translate, this.y, this.z);
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
        return this;
    }

    public Vertex translateY(float translate) {
        Vertex v1 = new Vertex(this.x, this.y + translate, this.z);
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
        return this;
    }

    public Vertex rotateY(float rotY) {
        double rotYRad = Math.toRadians(rotY);
        float newX = (float)((double)this.x * Math.cos(rotYRad) + (double)this.z * Math.sin(rotYRad));
        float newY = this.y;
        float newZ = (float)((double)(-this.x) * Math.sin(rotYRad) + (double)this.z * Math.cos(rotYRad));
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vertex rotateX(float rotX) {
        double rotXRad = Math.toRadians(rotX);
        float newX = this.x;
        float newY = (float)((double)(-this.z) * Math.sin(rotXRad) + (double)this.y * Math.cos(rotXRad));
        float newZ = (float)((double)this.y * Math.sin(rotXRad) + (double)this.z * Math.cos(rotXRad));
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vertex cross(Vertex other) {
        Vertex v1 = new Vertex(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
        return v1;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "Vertex{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return this.x == vertex.x && this.y == vertex.y && this.z == vertex.z;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public Vertex translateZ(int i) {
        Vertex v1 = new Vertex(this.x, this.y, this.z + (float)i);
        this.x = v1.x;
        this.y = v1.y;
        this.z = v1.z;
        return this;
    }

    public Vertex rotateZ(int rotZ) {
        double rotZRad = Math.toRadians(rotZ);
        float newX = (float)((double)this.x * Math.cos(rotZRad) - (double)this.y * Math.sin(rotZRad));
        float newY = (float)((double)this.x * Math.sin(rotZRad) + (double)this.y * Math.cos(rotZRad));
        float newZ = this.z;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public boolean isBehind(Plane partition) {
        float d = -(partition.location.x * partition.normal.x + partition.location.y * partition.normal.y + partition.location.z * partition.normal.z);
        float res = this.x * partition.normal.x + this.y * partition.normal.y + this.z * partition.normal.z + d;
        return !(res > 0.0f);
    }

    public boolean isInFront(Plane partition) {
        float d = -(partition.location.x * partition.normal.x + partition.location.y * partition.normal.y + partition.location.z * partition.normal.z);
        float res = this.x * partition.normal.x + this.y * partition.normal.y + this.z * partition.normal.z + d;
        return !(res < 0.0f);
    }

    public Vertex transform(float[][] matrix) {
        float nx = this.x * matrix[0][0] + this.y * matrix[0][1] + this.z * matrix[0][2] + matrix[0][3];
        float ny = this.x * matrix[1][0] + this.y * matrix[1][1] + this.z * matrix[1][2] + matrix[1][3];
        float nz = this.x * matrix[2][0] + this.y * matrix[2][1] + this.z * matrix[2][2] + matrix[2][3];
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Vertex project(float[][] matrix) {
        float nx = this.x * matrix[0][0] + matrix[0][2];
        float ny = this.y * matrix[1][1] + matrix[1][2];
        this.x = nx;
        this.y = ny;
        return this;
    }
}

