/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry;

import dev.secondsun.geometry.Texture;
import dev.secondsun.geometry.Vertex;

public class Triangle {
    public Vertex v1;
    public Vertex v2;
    public Vertex v3;
    public int textureId;
    public Texture texture;

    public Triangle(Vertex v1, Vertex v2, Vertex v3, int textureId, Texture texture) {
        this.v1 = new Vertex(v1);
        this.v2 = new Vertex(v2);
        this.v3 = new Vertex(v3);
        this.textureId = textureId;
        this.texture = texture;
    }

    public Triangle(Vertex v1, Vertex v2, Vertex v3, int textureId) {
        this.v1 = new Vertex(v1);
        this.v2 = new Vertex(v2);
        this.v3 = new Vertex(v3);
        this.textureId = textureId;
        this.texture = null;
    }

    public Triangle scale(float factor) {
        Triangle newTri = new Triangle(this.v1.scale(factor), this.v2.scale(factor), this.v3.scale(factor), this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle translateX(int translate) {
        Triangle newTri = new Triangle(this.v1.translateX(translate), this.v2.translateX(translate), this.v3.translateX(translate), this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle translateZ(int translate) {
        Triangle newTri = new Triangle(this.v1.translateZ(translate), this.v2.translateZ(translate), this.v3.translateZ(translate), this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle translateY(int translate) {
        Triangle newTri = new Triangle(this.v1.translateY(translate), this.v2.translateY(translate), this.v3.translateY(translate), this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle rotateY(int rotY) {
        Vertex v1New = this.v1.rotateY(rotY);
        Vertex v2New = this.v2.rotateY(rotY);
        Vertex v3New = this.v3.rotateY(rotY);
        Triangle newTri = new Triangle(v1New, v2New, v3New, this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle rotateZ(int rotZ) {
        Vertex v1New = this.v1.rotateZ(rotZ);
        Vertex v2New = this.v2.rotateZ(rotZ);
        Vertex v3New = this.v3.rotateZ(rotZ);
        Triangle newTri = new Triangle(v1New, v2New, v3New, this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Triangle rotateX(int rotX) {
        Vertex v1New = this.v1.rotateX(rotX);
        Vertex v2New = this.v2.rotateX(rotX);
        Vertex v3New = this.v3.rotateX(rotX);
        Triangle newTri = new Triangle(v1New, v2New, v3New, this.textureId, this.texture);
        this.v1 = newTri.v1;
        this.v2 = newTri.v2;
        this.v3 = newTri.v3;
        return this;
    }

    public Vertex normal() {
        Vertex line1 = new Vertex(this.v2.x - this.v1.x, this.v2.y - this.v1.y, this.v2.z - this.v1.z);
        Vertex line2 = new Vertex(this.v3.x - this.v1.x, this.v3.y - this.v1.y, this.v3.z - this.v1.z);
        return line1.cross(line2);
    }

    public Vertex center() {
        return new Vertex((this.v1.x + this.v2.x + this.v3.x) / 3.0f, (this.v1.y + this.v2.y + this.v3.y) / 3.0f, (this.v1.z + this.v2.z + this.v3.z) / 3.0f);
    }

    public Triangle transform(float[][] matrix) {
        this.v1.transform(matrix);
        this.v2.transform(matrix);
        this.v3.transform(matrix);
        return this;
    }

    public Triangle project(float[][] fovMatrix) {
        this.v1.project(fovMatrix);
        this.v2.project(fovMatrix);
        this.v3.project(fovMatrix);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.texture == null ? 0 : this.texture.hashCode());
        result = 31 * result + this.textureId;
        result = 31 * result + (this.v1 == null ? 0 : this.v1.hashCode());
        result = 31 * result + (this.v2 == null ? 0 : this.v2.hashCode());
        result = 31 * result + (this.v3 == null ? 0 : this.v3.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Triangle other = (Triangle)obj;
        if (this.texture == null ? other.texture != null : !this.texture.equals(other.texture)) {
            return false;
        }
        if (this.textureId != other.textureId) {
            return false;
        }
        if (this.v1 == null ? other.v1 != null : !this.v1.equals(other.v1)) {
            return false;
        }
        if (this.v2 == null ? other.v2 != null : !this.v2.equals(other.v2)) {
            return false;
        }
        return !(this.v3 == null ? other.v3 != null : !this.v3.equals(other.v3));
    }
}

