/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopApiProcessor;
import dev.shortloop.agent.ShortloopHTTPConnection;
import dev.shortloop.agent.ShortloopHttpConnectionConfig;
import dev.shortloop.agent.ShortloopNoOpFilter;
import dev.shortloop.agent.ShortloopSpringFilter;
import dev.shortloop.agent.buffer.DiscoveredApiBufferManager;
import dev.shortloop.agent.buffer.RegisteredApiBufferManager;
import dev.shortloop.agent.config.SimpleConfigManager;
import java.util.Random;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"shortloop.enabled"}, havingValue="true")
@Import(value={ShortloopHttpConnectionConfig.class})
public class ShortloopAutoConfiguration {
    @Value(value="${shortloop.url:}")
    private String url;
    @Value(value="${shortloop.applicationName:}")
    private String userApplicationName;
    @Value(value="${shortloop.loggingEnabled:false}")
    private boolean loggingEnabled;
    @Value(value="${shortloop.logLevel:ERROR}")
    private String logLevel;
    @Value(value="${shortloop.authKey:}")
    private String authKey;

    @Bean
    @Qualifier(value="shortloop-filter")
    @ConditionalOnProperty(prefix="shortloop", name={"url"})
    OncePerRequestFilter getShortloopSpringFilter(ShortloopHttpConnectionConfig shortloopHttpConnectionConfig) {
        SDKLogger.LogLevel logLevel = null == this.logLevel ? SDKLogger.LogLevel.ERROR : SDKLogger.LogLevel.valueOf(this.logLevel);
        SDKLogger sdkLogger = new SDKLogger(this.loggingEnabled, logLevel);
        if (null == this.url || this.url.length() == 0) {
            String message = "Mandatory Config `shortloop.url` is missing";
            System.out.println(message);
            sdkLogger.forceLog(message);
            return new ShortloopNoOpFilter();
        }
        if (null == this.userApplicationName || this.userApplicationName.length() == 0) {
            String message = "Mandatory Config `shortloop.applicationName` is missing";
            System.out.println(message);
            sdkLogger.forceLog(message);
            return new ShortloopNoOpFilter();
        }
        this.url = this.url.trim();
        this.userApplicationName = this.userApplicationName.trim();
        Random random = new Random();
        int randomId = random.nextInt(1000);
        String agentId = String.valueOf(randomId);
        ShortloopHTTPConnection shortloopHTTPConnection = new ShortloopHTTPConnection(this.url, this.userApplicationName, agentId, shortloopHttpConnectionConfig, sdkLogger, this.authKey);
        SimpleConfigManager configManager = new SimpleConfigManager(this.url, this.userApplicationName, agentId, shortloopHTTPConnection, sdkLogger);
        configManager.init();
        RegisteredApiBufferManager registeredApiBufferManager = new RegisteredApiBufferManager(configManager, shortloopHTTPConnection, this.url, sdkLogger);
        registeredApiBufferManager.init();
        DiscoveredApiBufferManager discoveredApiBufferManager = new DiscoveredApiBufferManager(configManager, shortloopHTTPConnection, this.url, sdkLogger);
        discoveredApiBufferManager.init();
        ShortloopApiProcessor shortloopApiProcessor = new ShortloopApiProcessor(registeredApiBufferManager, discoveredApiBufferManager, sdkLogger);
        ShortloopSpringFilter shortloopSpringFilter = new ShortloopSpringFilter(configManager, shortloopApiProcessor, this.userApplicationName, sdkLogger);
        shortloopSpringFilter.init();
        String message = String.format("Shortloop Initialised!\napplicationName:: %s\nurl:: %s\nagentId:: %s\nSDK Version:: %s.%s", this.userApplicationName, this.url, agentId, "1", "2");
        System.out.println(message);
        sdkLogger.forceLog(message);
        return shortloopSpringFilter;
    }
}

