/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopApiProcessor;
import dev.shortloop.agent.ShortloopHttpClient;
import dev.shortloop.agent.ShortloopHttpClientConfig;
import dev.shortloop.agent.ShortloopSpringFilter;
import dev.shortloop.agent.buffer.DiscoveredApiBufferManager;
import dev.shortloop.agent.buffer.RegisteredApiBufferManager;
import dev.shortloop.agent.config.SimpleConfigManager;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"shortloop.enabled"}, havingValue="true")
@Import(value={ShortloopHttpClientConfig.class})
public class ShortloopAutoConfiguration {
    @Value(value="${shortloop.ctUrl:}")
    private String ctUrl;
    @Value(value="${shortloop.applicationName:}")
    private String userApplicationName;
    @Value(value="${shortloop.loggingEnabled:false}")
    private boolean loggingEnabled;
    @Value(value="${shortloop.logLevel:ERROR}")
    private String logLevel;

    @Bean
    @ConditionalOnProperty(prefix="shortloop", name={"ctUrl"})
    ShortloopSpringFilter getShortloopSpringFilter(ShortloopHttpClientConfig shortloopHttpClientConfig) {
        if (StringUtils.isEmpty((CharSequence)this.ctUrl)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.userApplicationName)) {
            return null;
        }
        SDKLogger.LogLevel logLevel = null == this.logLevel ? SDKLogger.LogLevel.ERROR : SDKLogger.LogLevel.valueOf(this.logLevel);
        SDKLogger sdkLogger = new SDKLogger(this.loggingEnabled, logLevel);
        ShortloopHttpClient shortloopHttpClient = new ShortloopHttpClient(shortloopHttpClientConfig);
        Random random = new Random();
        int randomId = random.nextInt(1000);
        String agentId = String.valueOf(randomId);
        SimpleConfigManager configManager = new SimpleConfigManager(this.ctUrl, this.userApplicationName, agentId, shortloopHttpClient, sdkLogger);
        configManager.init();
        RegisteredApiBufferManager registeredApiBufferManager = new RegisteredApiBufferManager(configManager, shortloopHttpClient, this.ctUrl, sdkLogger);
        registeredApiBufferManager.init();
        DiscoveredApiBufferManager discoveredApiBufferManager = new DiscoveredApiBufferManager(configManager, shortloopHttpClient, this.ctUrl, sdkLogger);
        discoveredApiBufferManager.init();
        ShortloopApiProcessor shortloopApiProcessor = new ShortloopApiProcessor(registeredApiBufferManager, discoveredApiBufferManager, sdkLogger);
        ShortloopSpringFilter shortloopSpringFilter = new ShortloopSpringFilter(configManager, shortloopApiProcessor, this.userApplicationName, sdkLogger);
        shortloopSpringFilter.init();
        String message = String.format("Shortloop Initialised!\napplicationName:: %s\nctUrl:: %s\nagentId:: %s\nSDK Version:: %s.%s", this.userApplicationName, this.ctUrl, agentId, "1", "2");
        System.out.println(message);
        sdkLogger.forceLog(message);
        return shortloopSpringFilter;
    }
}

