/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.shortloop.agent.HttpException;
import dev.shortloop.agent.HttpRequest;
import dev.shortloop.agent.ShortloopHttpClientConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeaderElementIterator;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

public class ShortloopHttpClient {
    ShortloopHttpClientConfig shortloopHttpClientConfig;
    private RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy() {
        return (httpResponse, httpContext) -> {
            HeaderIterator headerIterator = httpResponse.headerIterator("Keep-Alive");
            BasicHeaderElementIterator elementIterator = new BasicHeaderElementIterator(headerIterator);
            while (elementIterator.hasNext()) {
                HeaderElement element = elementIterator.nextElement();
                String param = element.getName();
                String value = element.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return this.shortloopHttpClientConfig.getDefaultKeepAliveTime().intValue();
        };
    }

    private CloseableHttpClient getCloseableHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.shortloopHttpClientConfig.getConnectTimeout().intValue()).setConnectionRequestTimeout(this.shortloopHttpClientConfig.getConnectionRequestTimeout().intValue()).setSocketTimeout(this.shortloopHttpClientConfig.getSocketTimeout().intValue()).build();
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler(this.shortloopHttpClientConfig.getRetryCount(), false);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestConfig);
        builder.setKeepAliveStrategy(this.connectionKeepAliveStrategy());
        builder.setMaxConnPerRoute(this.shortloopHttpClientConfig.getMaxConnPerRoute().intValue());
        builder.setMaxConnTotal(this.shortloopHttpClientConfig.getMaxConnTotal().intValue());
        builder.setRetryHandler((HttpRequestRetryHandler)retryHandler);
        builder.evictIdleConnections((long)this.shortloopHttpClientConfig.getIdleConnectionWaitTime().intValue(), TimeUnit.MILLISECONDS);
        return builder.build();
    }

    public ShortloopHttpClient(ShortloopHttpClientConfig shortloopHttpClientConfig) {
        this.shortloopHttpClientConfig = shortloopHttpClientConfig;
        this.objectMapper = new ObjectMapper();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setHttpClient((HttpClient)this.getCloseableHttpClient());
        DefaultUriBuilderFactory defaultUriBuilderFactory = new DefaultUriBuilderFactory();
        defaultUriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)clientHttpRequestFactory)).uriTemplateHandler((UriTemplateHandler)defaultUriBuilderFactory).build();
    }

    public <IN, OUT> ResponseEntity<OUT> getRequest(HttpRequest<IN, OUT> requestDetail) throws HttpException {
        return this.request(requestDetail, HttpMethod.GET);
    }

    public <IN, OUT> ResponseEntity<OUT> postRequest(HttpRequest<IN, OUT> requestDetail) throws HttpException {
        return this.request(requestDetail, HttpMethod.POST);
    }

    private <IN, OUT> ResponseEntity<OUT> request(HttpRequest<IN, OUT> requestInfo, HttpMethod method) throws HttpException {
        try {
            Object url = requestInfo.getUrl();
            if (requestInfo.getQueryParams() != null) {
                url = (String)url + ShortloopHttpClient.getQueryParams(requestInfo.getQueryParams());
            }
            HttpHeaders httpHeaders = this.getHttpHeader(requestInfo.getRequestHeaders());
            ResponseEntity response = this.restTemplate.exchange((String)url, method, new HttpEntity(requestInfo.getRequestBody(), (MultiValueMap)httpHeaders), String.class, new Object[0]);
            Object res = ObjectUtils.isEmpty((Object)response.getBody()) ? null : this.objectMapper.readValue((String)response.getBody(), requestInfo.getResponseType());
            return new ResponseEntity(res, (MultiValueMap)response.getHeaders(), response.getStatusCode());
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    private HttpHeaders getHttpHeader(Map<String, String> headerMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (!ObjectUtils.isEmpty(headerMap)) {
            for (String key : headerMap.keySet()) {
                headers.set(key, headerMap.get(key));
            }
        }
        return headers;
    }

    public static String getQueryParams(Map<String, String> params) throws UnsupportedEncodingException {
        if (ObjectUtils.isEmpty(params)) {
            return "";
        }
        UriComponentsBuilder componentsBuilder = UriComponentsBuilder.newInstance();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            componentsBuilder.queryParam(entry.getKey(), new Object[]{URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString())});
        }
        return componentsBuilder.build().toString();
    }
}

