package dev.shortloop.agent;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Getter
@Setter
@Configuration
public class ShortloopHttpConnectionConfig {
    @Value("#{new Integer('${shortloop.http.maxTotalConnections:3}')}")
    private Integer maxConnTotal;

    @Value("#{new Integer('${shortloop.http.socketTimeoutMs:6000}')}")
    private Integer socketTimeout;

    @Value("#{new Integer('${shortloop.http.connectTimeoutMs:6000}')}")
    private Integer connectTimeout;

    @Value("#{new Integer('${shortloop.http.readTimeout:6000}')}")
    private Integer readTimeout;

    @Value("#{new Integer('${shortloop.http.connectionRequestTimeoutMs:6000}')}")
    private Integer connectionRequestTimeout;

    @Value("#{new Integer('${shortloop.http.maxSingleRouteConnections:3}')}")
    private Integer maxConnPerRoute;

    @Value("#{new Integer('${shortloop.http.idleConnectionWaitTimeMs:30000}')}")
    private Integer idleConnectionWaitTime;

    @Value("#{new Integer('${shortloop.http.defaultKeepAliveTimeMs:30000}')}")
    private Integer defaultKeepAliveTime;

    @Value("#{new Integer('${shortloop.http.maxRetries:3}')}")
    private int retryCount;
}
