/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.commons.ObservedApi;
import dev.shortloop.common.models.constant.ShortloopCommonConstant;
import dev.shortloop.common.models.data.AgentConfig;
import dev.shortloop.common.models.data.URI;

public class ApiBufferKey {
    private final URI uri;
    private final ShortloopCommonConstant.HttpRequestMethod method;

    public static ApiBufferKey getApiBufferKeyFrom(ObservedApi observedApi) {
        return new ApiBufferKey(observedApi.getUri(), observedApi.getMethod());
    }

    public static ApiBufferKey getApiBufferKeyFrom(AgentConfig.ApiConfig apiConfig) {
        return new ApiBufferKey(apiConfig.getUri(), apiConfig.getMethod());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ApiBufferKey other = (ApiBufferKey)object;
        return this.method.equals((Object)other.getMethod()) && this.uri.equals((Object)other.getUri());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.uri.hashCode();
        result = result * 59 + this.method.hashCode();
        return result;
    }

    public ApiBufferKey(URI uri, ShortloopCommonConstant.HttpRequestMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public URI getUri() {
        return this.uri;
    }

    public ShortloopCommonConstant.HttpRequestMethod getMethod() {
        return this.method;
    }
}

