/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.config;

import dev.shortloop.common.models.data.AgentConfig;
import dev.shortloop.common.models.data.DataSize;
import dev.shortloop.common.models.data.Period;
import dev.shortloop.common.models.data.URI;

public class AgentConfigUtils {
    public static boolean isConfigValid(AgentConfig agentConfig) {
        if (null == agentConfig) {
            return false;
        }
        if (null == agentConfig.getBufferSyncFreqInSec()) {
            return false;
        }
        if (null == agentConfig.getConfigFetchFreqInSec()) {
            return false;
        }
        if (null == agentConfig.getCaptureApiSample()) {
            return false;
        }
        if (null == agentConfig.getDiscoveryBufferSize()) {
            return false;
        }
        if (null == agentConfig.getDiscoveryBufferSizePerApi()) {
            return false;
        }
        if (null != agentConfig.getRegisteredApiConfigs()) {
            for (AgentConfig.ApiConfig apiConfig : agentConfig.getRegisteredApiConfigs()) {
                if (AgentConfigUtils.isApiConfigValid(apiConfig)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isApiConfigValid(AgentConfig.ApiConfig apiConfig) {
        if (null == apiConfig) {
            return false;
        }
        if (!AgentConfigUtils.isURIValid(apiConfig.getUri())) {
            return false;
        }
        if (null == apiConfig.getMethod()) {
            return false;
        }
        if (null == apiConfig.getBufferSize()) {
            return false;
        }
        if (null == apiConfig.getCaptureSampleRequest()) {
            return false;
        }
        return null != apiConfig.getCaptureSampleResponse();
    }

    static boolean isURIValid(URI uri) {
        if (null == uri) {
            return false;
        }
        return null != uri.getUriPath() && uri.getUriPath().length() != 0;
    }

    static boolean isDataSizeValid(DataSize dataSize) {
        if (null == dataSize) {
            return false;
        }
        return dataSize.getDataValue() >= 0 && dataSize.getDataUnit() != null;
    }

    static boolean isPeriodValid(Period period) {
        if (null == period) {
            return false;
        }
        return period.getTimeValue() >= 0 && period.getTimeUnit() != null;
    }
}

