/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.flow.assertions.booleans;

import dev.tidalcode.flow.assertions.booleans.BoolAssert;
import dev.tidalcode.flow.assertions.stackbuilder.ErrorStack;

public class BoolAssertion
extends BoolAssert<Boolean> {
    public BoolAssertion(String description, boolean actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    public BoolAssert<Boolean> isTrue() {
        if (Boolean.FALSE.equals(this.actual)) {
            this.status = false;
        }
        new ErrorStack.Builder("Value expected to be true but was false", this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public BoolAssert<Boolean> isFalse() {
        if (Boolean.TRUE.equals(this.actual)) {
            this.status = false;
        }
        new ErrorStack.Builder("Value expected to be false but was true", this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

