/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.flow.assertions.maps;

import dev.tidalcode.flow.assertions.NullCheck;
import dev.tidalcode.flow.assertions.maps.MapAssert;
import dev.tidalcode.flow.assertions.stackbuilder.ErrorStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MapAssertion<T, V>
extends MapAssert<T, V> {
    public MapAssertion(String description, Map<T, V> actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    @SafeVarargs
    public final MapAssert<T, V> containsKeys(T ... keys) {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", keys, this.softAssertion)) {
            return this;
        }
        Set keysSet = ((Map)this.actual).keySet();
        Arrays.stream(keys).forEach(k -> {
            this.status = keysSet.contains(k);
            String errorDetails = String.format("Map '%s' does not contain key '%s'", this.actual, k);
            ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    @SafeVarargs
    public final MapAssert<T, V> containsValues(V ... values) {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", values, this.softAssertion)) {
            return this;
        }
        Collection actualValues = ((Map)this.actual).values();
        Arrays.stream(values).forEach(v -> {
            this.status = actualValues.contains(v);
            String errorDetails = String.format("Map '%s' does not contain value '%s'", this.actual, v);
            ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    public final MapAssert<T, V> containsKeyAndValue(T key, V value) {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (value.getClass() == String.class && !((Map)this.actual).get(key).equals(value)) {
            this.status = false;
        } else if (((Map)this.actual).get(key) != value) {
            this.status = false;
        }
        String errorDetails = String.format("Failed to find the value '%s' with key '%s' from the map '%s'", value, key, this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public MapAssert<T, V> isEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion)) {
            return this;
        }
        if (!((Map)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetails = String.format("Map '%s' is not an empty map", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public MapAssert<T, V> isNotEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion)) {
            return this;
        }
        if (((Map)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetails = String.format("Map '%s' is an empty map", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public MapAssert<T, V> isSameTypeAs(Map<?, ?> value) {
        if (NullCheck.assertNull("Actual, input value is", (Map)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        Map actualMapCopy = (Map)this.actual;
        Map<?, ?> valueMapCopy = value;
        Object t = null;
        Optional actualKeyFirst = ((Map)this.actual).keySet().stream().findFirst();
        if (actualKeyFirst.isPresent()) {
            t = actualKeyFirst.get();
        }
        Object compareKey = null;
        Optional valueOneKeySet = value.keySet().stream().findFirst();
        if (valueOneKeySet.isPresent()) {
            compareKey = valueOneKeySet.get();
        }
        Object v = null;
        Optional actualValueFirst = ((Map)this.actual).values().stream().findFirst();
        if (actualValueFirst.isPresent()) {
            v = actualValueFirst.get();
        }
        Object compareValue = null;
        Optional<?> valueTwoValue = value.values().stream().findFirst();
        if (valueTwoValue.isPresent()) {
            compareValue = valueTwoValue.get();
        }
        if (NullCheck.assertNull(String.format("Actual map %s key ", actualMapCopy), t, this.softAssertion) || NullCheck.assertNull(String.format("Comparison map %s key", valueMapCopy), compareKey, this.softAssertion)) {
            return this;
        }
        if (t.getClass() != compareKey.getClass() || v.getClass() != compareValue.getClass()) {
            this.status = false;
        }
        String errorDetails = String.format("Maps '%s' and '%s' are not of the same type", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

