/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.flow.assertions.strings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.tidalcode.flow.assertions.NullCheck;
import dev.tidalcode.flow.assertions.stackbuilder.ErrorStack;
import dev.tidalcode.flow.assertions.strings.StringAssert;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringAssertion
extends StringAssert<String> {
    public StringAssertion(String description, String actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    public StringAssert<String> isNotNullOrEmpty() {
        if (this.actual == null || ((String)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetails = "Given value is either null or empty";
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> isNullOrEmpty() {
        if (this.actual != null && !((String)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetails = "Given value is not null or empty";
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> contains(String value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((String)this.actual).contains(value)) {
            this.status = false;
        }
        String errorDetails = String.format("'%s' does not contain value '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> startsWith(String value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((String)this.actual).startsWith(value)) {
            this.status = false;
        }
        String errorDetails = String.format("'%s' does not start with '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> endsWith(String value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((String)this.actual).endsWith(value)) {
            this.status = false;
        }
        String errorDetails = String.format("'%s' does not end with '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> matchesPattern(String charPattern) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", charPattern, this.softAssertion)) {
            return this;
        }
        Pattern pattern = Pattern.compile(charPattern);
        Matcher matcher = pattern.matcher((CharSequence)this.actual);
        if (!matcher.matches()) {
            this.status = false;
        }
        String errorDetails = String.format(" Pattern '%s' could not be matched with given value '%s'", charPattern, this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> equalsIgnoringCase(String value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((String)this.actual).equalsIgnoreCase(value)) {
            this.status = false;
        }
        String errorDetails = String.format("'%s' is not equals to '%s' [Case Ignored]", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> hasCharCount(int value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        if (((String)this.actual).length() != value) {
            this.status = false;
        }
        String errorDetails = String.format("Expected character count was '%d' but actual was '%d'", value, ((String)this.actual).length());
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> hasAlphaNumericCharCount(int value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        int actualLength = ((String)this.actual).replaceAll("[^0-9a-zA-Z]", "").length();
        if (actualLength != value) {
            this.status = false;
        }
        String errorDetails = String.format("Expected character count was '%d' but actual was '%d'", value, actualLength);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> containsOnlyLetters() {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        int parsedLength = ((String)this.actual).replaceAll("[ (\n)a-zA-Z]", "").length();
        if (parsedLength > 0) {
            this.status = false;
        }
        String errorDetails = String.format("String '%s' contains characters other than letters", ((String)this.actual).replaceAll("[\n\t\r]", " "));
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> containsOnlyNumbers() {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        int parsedLength = ((String)this.actual).replaceAll("[ 0-9]", "").length();
        if (parsedLength > 0) {
            this.status = false;
        }
        String errorDetails = String.format("String '%s' contains characters other than numbers", ((String)this.actual).replaceAll("[\n\t\r]", " "));
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> containsNumbersOfSize(int value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        int parsedLength = ((String)this.actual).replaceAll("[^0-9]", "").length();
        if (parsedLength != value) {
            this.status = false;
        }
        String errorDetails = String.format("Expected count of numbers in actual string '%s' was '%s'; but got '%s'", this.actual, value, parsedLength);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> isValidJson() {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion)) {
            return this;
        }
        String jsonValidationError = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree((String)this.actual);
        }
        catch (JsonProcessingException e) {
            jsonValidationError = e.getMessage();
            this.status = false;
        }
        String errorDetails = String.format("Supplied string: %s \n is not a valid json. \n %s", this.actual, jsonValidationError);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public StringAssert<String> matchesJson(String value) {
        if (NullCheck.assertNull("Actual, input value is", (String)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        String errorDetails = "";
        boolean jsonParseException_Actual = false;
        boolean jsonParseException_Value = false;
        JsonNode mapperForActual = null;
        JsonNode mapperForValue = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapperForActual = mapper.readTree((String)this.actual);
        }
        catch (JsonProcessingException e) {
            jsonParseException_Actual = true;
            errorDetails = String.format("Matching Json comparison cannot be performed as 'actual' input json is not valid. \n %s", e.getMessage());
        }
        try {
            mapperForValue = mapper.readTree(value);
        }
        catch (JsonProcessingException e) {
            jsonParseException_Value = true;
            errorDetails = String.format("Matching Json comparison cannot be performed as 'expected' input json is not valid. \n %s", e.getMessage());
        }
        if (jsonParseException_Actual || jsonParseException_Value) {
            this.status = false;
        } else {
            this.status = mapperForActual.equals((Object)mapperForValue);
            errorDetails = String.format("Actual value %s is not equal to comparison value %s", this.actual, value);
        }
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

