/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.azure.screenshots;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.jayway.jsonpath.PathNotFoundException;
import com.tidal.stream.azure.screenshots.AzureAttachmentModel;
import com.tidal.stream.azure.screenshots.AzurePipelineInfo;
import com.tidal.stream.azure.screenshots.AzureSSOperations;
import com.tidal.stream.azure.screenshots.AzureTestCaseModel;
import com.tidal.stream.httpRequest.ReqType;
import com.tidal.stream.httpRequest.Request;
import com.tidal.utils.exceptions.AzureOperationsException;
import com.tidal.utils.filehandlers.FilePaths;
import com.tidal.utils.filehandlers.FileReader;
import com.tidal.utils.filehandlers.Finder;
import com.tidal.utils.json.JsonReader;
import com.tidal.utils.json.JsonWriter;
import com.tidal.utils.utils.Helper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Credentials;
import org.apache.log4j.Logger;

public class AzureScreenshotOperations
implements AzureSSOperations {
    private static final Logger logger = Logger.getLogger(AzureScreenshotOperations.class);
    private static final String AUTHENTICATION_HEADER_NAME = "Authorization";
    private static final String JSON_PATH_LATEST_RUN_ID = "value[0].id";
    private static final String JSON_PATH_TEST_CASE_ID = "value[%d].id";
    private static final String JSON_PATH_TEST_CASE_NAME = "value[%d].testCase.name";
    private final String authorizationCredential;
    private final String buildUri;
    private final String azureUri;
    private static final Path TARGET_FOLDER_PATH = Paths.get(Helper.getAbsoluteFromRelativePath((String)FilePaths.TARGET_FOLDER_PATH.getPath()), new String[0]);

    public AzureScreenshotOperations(AzurePipelineInfo azurePipelineInfo) {
        this.buildUri = azurePipelineInfo.getAzureBuildUri();
        this.authorizationCredential = Credentials.basic((String)"", (String)azurePipelineInfo.getAzureToken());
        this.azureUri = String.format("%s/%s/_apis/", azurePipelineInfo.getAzureDevopsOrgName(), azurePipelineInfo.getAzureDevopsProjectName());
    }

    @Override
    public int getLatestTestRunId(String buildUri) {
        int result;
        try {
            logger.info((Object)("Finding the test run for build URI: " + buildUri));
            String endPoint = this.azureUri + String.format("test/runs?buildUri=%s", buildUri);
            Request.set(endPoint);
            Request.setHeader(AUTHENTICATION_HEADER_NAME, this.authorizationCredential);
            Request.send(ReqType.GET);
            result = (Integer)JsonReader.readValue((String)JSON_PATH_LATEST_RUN_ID, (String)Request.getResponseString());
            logger.info((Object)("The test run ID in Azure for for build URI: " + buildUri + " is " + result));
            Request.reset();
        }
        catch (PathNotFoundException exception) {
            logger.info((Object)("Unable to find a test run in Azure for build URI: " + buildUri));
            throw new AzureOperationsException(exception.getMessage());
        }
        return result;
    }

    @Override
    public List<AzureTestCaseModel> getFailedTestCasesFromAzureTestRun(Integer runId) {
        ArrayList<AzureTestCaseModel> failedTestId = new ArrayList<AzureTestCaseModel>();
        try {
            String endPoint = this.azureUri + String.format("test/runs/%d/results?outcomes=Failed&?api-version=6.0", runId);
            Request.set(endPoint);
            Request.setHeader(AUTHENTICATION_HEADER_NAME, this.authorizationCredential);
            Request.send(ReqType.GET);
            String result = Request.getResponseString();
            int noOfFailedTests = (Integer)JsonReader.readValue((String)"count", (String)result);
            logger.info((Object)("No of failed tests in azure for the run " + runId + " is " + noOfFailedTests));
            for (int count = 0; count < noOfFailedTests; ++count) {
                AzureTestCaseModel azureTestCaseModel = new AzureTestCaseModel();
                String testCaseIdPath = String.format(JSON_PATH_TEST_CASE_ID, count);
                String testCaseNamePath = String.format(JSON_PATH_TEST_CASE_NAME, count);
                azureTestCaseModel.setTestCaseId((Integer)JsonReader.readValue((String)testCaseIdPath, (String)result));
                azureTestCaseModel.setTestCaseName((String)JsonReader.readValue((String)testCaseNamePath, (String)result));
                failedTestId.add(azureTestCaseModel);
            }
            Request.reset();
        }
        catch (PathNotFoundException exception) {
            logger.info((Object)("Unable to get run results for the test run ID " + runId));
            throw new AzureOperationsException(exception.getMessage());
        }
        return failedTestId;
    }

    @Override
    public void postScreenshotToAzure(int runId, List<AzureTestCaseModel> azureTestCaseModels) {
        logger.info((Object)("Starting upload process for failed tests under the run " + runId));
        azureTestCaseModels.parallelStream().forEach(azureTestCaseModel -> {
            String formattedScenarioName = azureTestCaseModel.getTestCaseName().replaceAll("[^a-zA-Z0-9]", "");
            if (Finder.findFileIfExists((String)(formattedScenarioName + ".txt"), (Path)TARGET_FOLDER_PATH).isPresent()) {
                String endPoint = this.azureUri + String.format("test/Runs/%d/Results/%d/attachments?api-version=5.1-preview.1", runId, azureTestCaseModel.getTestCaseId());
                Request.set(endPoint);
                Request.setHeader(AUTHENTICATION_HEADER_NAME, this.authorizationCredential);
                String payload = this.generateAzureScreenshotPayload((AzureTestCaseModel)azureTestCaseModel);
                Request.setPayload(payload);
                Request.send(ReqType.POST);
                Request.reset();
            }
        });
        logger.info((Object)"Uploading of screenshots to azure devops is completed");
    }

    @Override
    public String generateAzureScreenshotPayload(AzureTestCaseModel azureTestCaseModel) {
        logger.info((Object)("Generating upload payload for test case " + azureTestCaseModel.getTestCaseName()));
        AzureAttachmentModel azureAttachmentModel = new AzureAttachmentModel();
        String formattedScenarioName = azureTestCaseModel.getTestCaseName().replaceAll("[^a-zA-Z0-9]", "");
        String screenshotContent = FileReader.readFileToString((String)(formattedScenarioName + ".txt"), (Path)TARGET_FOLDER_PATH);
        azureAttachmentModel.setStream(screenshotContent);
        String fileNameForAzurePayload = azureTestCaseModel.getTestCaseName().replace(" ", "_").replaceAll("[^a-zA-Z0-9_]", "");
        azureAttachmentModel.setFileName(fileNameForAzurePayload + ".png");
        String payLoad = this.serializeModelClass(azureAttachmentModel);
        payLoad = new JsonWriter("fileName", payLoad).setValue((Object)(fileNameForAzurePayload + ".png")).extract();
        logger.info((Object)("Successfully generated payload for " + azureTestCaseModel.getTestCaseName()));
        return payLoad;
    }

    @Override
    public void uploadScreenShot() {
        try {
            logger.info((Object)("Build Uri for the current build is " + this.buildUri));
            int runId = this.getLatestTestRunId(this.buildUri);
            List<AzureTestCaseModel> testCaseModelList = this.getFailedTestCasesFromAzureTestRun(runId);
            this.postScreenshotToAzure(runId, testCaseModelList);
        }
        catch (AzureOperationsException ex) {
            logger.info((Object)"Failed to upload screenshot to azure devops");
            logger.info((Object)ex.getMessage());
        }
    }

    private String serializeModelClass(AzureAttachmentModel azureAttachmentModel) {
        try {
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            return ow.writeValueAsString((Object)azureAttachmentModel);
        }
        catch (JsonProcessingException ex) {
            logger.info((Object)"Failed to serialize the attachment model class");
            logger.info((Object)ex.getMessage());
            throw new AzureOperationsException("Failed to serialize the attachment model class for file " + azureAttachmentModel.getFileName());
        }
    }
}

