/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.httpRequest;

import com.tidal.stream.httpRequest.DataEnum;
import com.tidal.stream.httpRequest.ReqType;
import com.tidal.utils.exceptions.PropertyHandlerException;
import com.tidal.utils.exceptions.RuntimeTestException;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentRequest {
    private static final Logger logger = LoggerFactory.getLogger(FluentRequest.class);
    private final Function<String, String> timeOut = PropertiesFinder::getProperty;
    private final String BASE_URI = "baseURI";
    private final String MEDIA_TYPE = "mediaType";
    private final String PAYLOAD = "payload";
    private final String RESPONSE_STRING = "responseString";
    private final String QUERY_PARAM_ONE_KEY = "queryParamOneKey";
    private final String QUERY_PARAM_TWO_KEY = "queryParamTwoKey";
    private final String QUERY_PARAM_THREE_KEY = "queryParamThreeKey";
    private OkHttpClient client;
    private Response response;
    private Request httpRequest;
    private HashMap<String, Object> dataMap;
    private Map<String, Object> headerMap;
    private Map<String, Object> queryParamMap;
    private Headers requestHeaders;
    private final UnaryOperator<String> readTimeOut = s -> {
        try {
            return this.timeOut.apply((String)s) == null ? "10" : this.timeOut.apply((String)s);
        }
        catch (PropertyHandlerException ignored) {
            return "10";
        }
    };

    public void setHttpRequest(Request builtRequest) {
        this.httpRequest = builtRequest;
    }

    public FluentRequest set() {
        this.client = this.getNewOkHttpClient();
        this.createMap();
        logger.info("Creating a basic OKHttp client without a url");
        return this;
    }

    public FluentRequest set(String baseUri) {
        if (this.client == null) {
            this.client = this.getNewOkHttpClient();
        }
        this.createMap();
        this.dataMap.put("baseURI", baseUri);
        logger.info("Creating a basic OKHttp client with a url {}", (Object)baseUri);
        return this;
    }

    public FluentRequest setBaseUri(String baseUri) {
        if (this.dataMap == null) {
            this.createMap();
        }
        logger.info("Resetting the original client with new url {}", (Object)baseUri);
        this.dataMap.put("baseURI", baseUri);
        return this;
    }

    public FluentRequest setMediaType(String mediaType) {
        this.dataMap.put("mediaType", mediaType);
        logger.info("Setting the media type as {}", (Object)mediaType);
        return this;
    }

    private OkHttpClient getNewOkHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("connection.timeout")))).readTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("read.timeout")))).writeTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("write.timeout")))).callTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("call.timeout")))).build();
    }

    public FluentRequest setHeader(String key, Object value) {
        this.headerMap.put(key, value);
        logger.info("Setting the header as {} : {}", (Object)key, value);
        return this;
    }

    public FluentRequest setQueryParams(String key, Object value) {
        this.queryParamMap.put(key, value);
        return this;
    }

    public FluentRequest setPayload(String payload) {
        this.dataMap.put("payload", payload);
        logger.info("Setting the payload:  {}", (Object)payload);
        return this;
    }

    public <T> FluentRequest setData(String key, T value) {
        this.dataMap.put(key, value);
        logger.info("Storing test context data {} : {}", (Object)key, value);
        return this;
    }

    public <T> FluentRequest setData(DataEnum data, T value) {
        this.createMap();
        this.dataMap.put(data.getValue(), value);
        logger.info("Storing test context data {} : {}", (Object)data.getValue(), value);
        return this;
    }

    public <T> T getData(String key) {
        return (T)this.dataMap.get(key);
    }

    public <T> Optional<T> getData(DataEnum data) {
        Object value;
        if (this.dataMap == null) {
            this.set();
        }
        if ((value = this.dataMap.get(data.getValue())) == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public FluentRequest send(ReqType reqType) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        if (this.dataMap.get("mediaType") != null) {
            mediaType = MediaType.parse((String)((String)this.dataMap.get("mediaType")));
        }
        RequestBody body = RequestBody.create((String)"", (MediaType)mediaType);
        if (this.dataMap.get("payload") != null) {
            body = RequestBody.create((String)((String)this.dataMap.get("payload")), (MediaType)mediaType);
        }
        this.applyHeaders();
        if (this.httpRequest == null) {
            Request.Builder requestBuilder = new Request.Builder().url(this.queryBuilder().build());
            switch (reqType) {
                case GET: {
                    this.httpRequest = requestBuilder.get().headers(this.requestHeaders).build();
                    break;
                }
                case HEAD: {
                    this.httpRequest = requestBuilder.head().headers(this.requestHeaders).build();
                    break;
                }
                case DELETE: {
                    this.httpRequest = requestBuilder.delete().headers(this.requestHeaders).build();
                    break;
                }
                default: {
                    this.httpRequest = requestBuilder.method(reqType.getRequestType().toUpperCase(Locale.ROOT), body).headers(this.requestHeaders).build();
                }
            }
            logger.info("Sending the request type as {} to the url {}", (Object)reqType, this.dataMap.get("baseURI"));
        }
        try {
            this.response = this.client.newCall(this.httpRequest).execute();
            if (this.dataMap.get("responseString") == null) {
                this.dataMap.put("responseString", this.response.body().string());
            }
            this.response.close();
            logger.info("Received the response: {}", this.dataMap.get("responseString"));
        }
        catch (IOException e) {
            throw new RuntimeTestException("IOException with request" + e.getMessage());
        }
        return this;
    }

    private HttpUrl.Builder queryBuilder() {
        HttpUrl.Builder builder = HttpUrl.get((String)((String)this.dataMap.get("baseURI"))).newBuilder();
        this.queryParamMap.forEach((k, v) -> builder.addQueryParameter(k, String.valueOf(v)));
        return builder;
    }

    private void applyHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        for (String key : this.headerMap.keySet()) {
            headerBuilder.add(key, (String)Objects.requireNonNull(this.headerMap.get(key)));
        }
        this.requestHeaders = headerBuilder.build();
    }

    public Response response() {
        if (this.response == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return this.response;
    }

    public int getStatusCode() {
        if (this.response == null) {
            throw new RuntimeTestException("Status code is null : Check if the request is sent");
        }
        return this.response.code();
    }

    public String getResponseString() {
        if (this.response == null) {
            throw new RuntimeTestException("Response string is null : Check if the request is sent");
        }
        return (String)this.dataMap.get("responseString");
    }

    private void createMap() {
        if (this.dataMap == null) {
            this.dataMap = new HashMap();
        }
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, Object>();
        }
        if (this.queryParamMap == null) {
            this.queryParamMap = new LinkedHashMap<String, Object>();
        }
    }
}

