/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.azure.testresults;

import com.tidal.stream.azure.AppConstants;
import com.tidal.stream.httpRequest.ReqType;
import com.tidal.stream.httpRequest.Request;
import com.tidal.utils.json.JsonReader;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;

public class TestRun {
    public int getTestRunId(String testRunName) {
        Request.set(PropertiesFinder.getProperty((String)"ado.testrun.endpoint"));
        Request.setHeader("Authorization", AppConstants.AZURE_AUTHORIZATION.get());
        Request.setMediaType("text/plain");
        Request.send(ReqType.GET);
        return this.extractRunId(testRunName, Request.getResponseString());
    }

    private int extractRunId(String testRunName, String responseString) {
        int resultSize = (Integer)JsonReader.readValue((String)"value.size()", (String)responseString);
        AtomicInteger lastResultId = new AtomicInteger();
        IntStream.range(0, resultSize).forEach(e -> {
            if (JsonReader.readValue((String)String.format("value.[%d].name", e), (String)responseString).equals(testRunName)) {
                lastResultId.set(Integer.parseInt((String)JsonReader.readValue((String)String.format("value.[%d].id", e), (String)responseString)));
            }
        });
        return lastResultId.get();
    }
}

