/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.filehandler;

import com.tidal.stream.exceptions.RuntimeTestException;
import com.tidal.stream.filehandler.FilePaths;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public class Finder {
    private static Path resourceFolder = Paths.get(FilePaths.getAbsoluteFromRelativePath(FilePaths.RESOURCE_FOLDER_PATH.getPath()), new String[0]);

    private Finder() {
    }

    public static void setFolder(String folder) {
        resourceFolder = Paths.get(folder, new String[0]);
    }

    public static void setTargetAsBaseFolder() {
        resourceFolder = Paths.get(FilePaths.getAbsoluteFromRelativePath(FilePaths.TARGET_FOLDER_PATH.getPath()), new String[0]);
    }

    public static void resetToResourceFolder() {
        resourceFolder = Paths.get(FilePaths.getAbsoluteFromRelativePath(FilePaths.RESOURCE_FOLDER_PATH.getPath()), new String[0]);
    }

    public static synchronized File findFile(String fileName) {
        return Finder.findFile(fileName, resourceFolder);
    }

    public static synchronized File findFile(String fileName, Path baseFolderPath) {
        File file;
        block8: {
            Stream<String> stringStream = Files.walk(baseFolderPath, new FileVisitOption[0]).map(Path::toString).filter(f -> f.contains(fileName));
            try {
                Optional<String> filePath = stringStream.findFirst();
                file = new File(filePath.orElseThrow(FileNotFoundException::new));
                if (stringStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stringStream != null) {
                        try {
                            stringStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.initCause(new FileNotFoundException(String.format("File with name '%s' cannot be found from the folder or subfolder of '%s'", fileName, resourceFolder)));
                    throw new RuntimeTestException(e.getCause());
                }
            }
            stringStream.close();
        }
        return file;
    }

    public static Optional<File> findFileIfExists(String fileName) {
        return Finder.findFileIfExists(fileName, resourceFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<File> findFileIfExists(String fileName, Path baseFolderPath) {
        try (Stream<String> stringStream = Files.walk(baseFolderPath, new FileVisitOption[0]).map(Path::toString).filter(f -> f.contains(fileName));){
            Optional<String> filePath = stringStream.findFirst();
            if (!filePath.isPresent()) return Optional.empty();
            Optional<File> optional = Optional.of(new File(filePath.get()));
            return optional;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String findFilePath(String fileName) {
        File foundFile = Finder.findFile(fileName);
        return foundFile.getPath();
    }

    public static String getAbsoluteFilePath(String fileName) {
        return FilePaths.getAbsoluteFromRelativePath(Finder.findFilePath(fileName));
    }

    public static void openFile(String htmlFileName) {
        File htmlFile = Finder.findFile(htmlFileName);
        try {
            Desktop.getDesktop().browse(htmlFile.toURI());
        }
        catch (IOException e) {
            throw new RuntimeTestException("Failed to open the file");
        }
    }
}

