/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.httpRequest;

import com.tidal.stream.httpRequest.ReqType;
import com.tidal.utils.exceptions.PropertyHandlerException;
import com.tidal.utils.exceptions.RuntimeTestException;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentRequest {
    private static final Logger logger = LoggerFactory.getLogger(FluentRequest.class);
    private final Function<String, String> timeOut = PropertiesFinder::getProperty;
    private OkHttpClient client;
    private String baseURI;
    private String mediaType;
    private String responseBody;
    private Response response;
    private String payload;
    private Request httpRequest;
    private HashMap<String, Object> dataMap;
    private Map<String, Object> headerMap;
    private Map<String, Object> queryParamMap;
    private Headers requestHeaders;
    private FormBody.Builder formBodyBuilder;
    private final UnaryOperator<String> readTimeOut = s -> {
        try {
            return this.timeOut.apply((String)s) == null ? "10" : this.timeOut.apply((String)s);
        }
        catch (PropertyHandlerException ignored) {
            return "10";
        }
    };

    public void setHttpRequest(Request builtRequest) {
        this.httpRequest = builtRequest;
    }

    public FluentRequest set(String baseURI) {
        if (this.client == null) {
            this.client = this.getNewOkHttpClient();
        }
        this.baseURI = baseURI;
        this.createMap();
        logger.info("Creating a basic OKHttp client with a url {}", (Object)baseURI);
        return this;
    }

    public FluentRequest setMediaType(String mediaType) {
        this.mediaType = mediaType;
        logger.info("Setting the media type as {}", (Object)mediaType);
        return this;
    }

    private OkHttpClient getNewOkHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("connection.timeout")))).readTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("read.timeout")))).writeTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("write.timeout")))).callTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("call.timeout")))).build();
    }

    public FluentRequest setHeader(String key, Object value) {
        this.headerMap.put(key, value);
        logger.info("Setting the header as {} : {}", (Object)key, value);
        return this;
    }

    public FluentRequest setBearerToken(String token) {
        this.headerMap.put("Authorization", "Bearer " + token);
        return this;
    }

    public FluentRequest setQueryParams(String key, Object value) {
        this.queryParamMap.put(key, value);
        return this;
    }

    public FluentRequest setFormParam(String key, String value) {
        if (null == this.formBodyBuilder) {
            this.formBodyBuilder = new FormBody.Builder();
        }
        this.formBodyBuilder.add(key, value);
        return this;
    }

    public FluentRequest setPayload(String payload) {
        this.payload = payload;
        logger.info("Setting the payload:  {}", (Object)payload);
        return this;
    }

    public FluentRequest send(ReqType reqType) {
        MediaType parsedMediatype = null;
        if (this.mediaType != null) {
            parsedMediatype = MediaType.parse((String)this.mediaType);
        }
        FormBody body = null;
        if (this.formBodyBuilder == null && this.payload != null) {
            body = RequestBody.create((String)this.payload, (MediaType)parsedMediatype);
        } else if (this.formBodyBuilder != null) {
            body = this.formBodyBuilder.build();
        }
        this.applyHeaders();
        if (this.httpRequest == null) {
            Request.Builder requestBuilder = new Request.Builder().url(this.queryBuilder().build());
            switch (reqType) {
                case GET: {
                    this.httpRequest = requestBuilder.get().headers(this.requestHeaders).build();
                    break;
                }
                case HEAD: {
                    this.httpRequest = requestBuilder.head().headers(this.requestHeaders).build();
                    break;
                }
                case DELETE: {
                    this.httpRequest = requestBuilder.delete().headers(this.requestHeaders).build();
                    break;
                }
                default: {
                    this.httpRequest = requestBuilder.method(reqType.getRequestType().toUpperCase(Locale.ROOT), (RequestBody)body).headers(this.requestHeaders).build();
                }
            }
            logger.info("Sending the request type as {} to the url {}", (Object)reqType, (Object)this.httpRequest.url());
        }
        try {
            this.response = this.client.newCall(this.httpRequest).execute();
            this.responseBody = this.response.body().string();
            this.response.close();
            logger.info("Response status: {} {}", (Object)this.response.code(), (Object)this.response.message());
            logger.info("Response Message: {}", (Object)this.responseBody);
        }
        catch (IOException e) {
            throw new RuntimeTestException("IOException with request" + e.getMessage());
        }
        return this;
    }

    private HttpUrl.Builder queryBuilder() {
        HttpUrl.Builder builder = HttpUrl.get((String)this.baseURI).newBuilder();
        this.queryParamMap.forEach((k, v) -> builder.addQueryParameter(k, String.valueOf(v)));
        return builder;
    }

    private void applyHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        for (String key : this.headerMap.keySet()) {
            headerBuilder.add(key, (String)Objects.requireNonNull(this.headerMap.get(key)));
        }
        this.requestHeaders = headerBuilder.build();
    }

    public Response response() {
        if (this.response == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return this.response;
    }

    public int getStatusCode() {
        if (this.response == null) {
            throw new RuntimeTestException("Status code is null : Check if the request is sent");
        }
        return this.response.code();
    }

    public String getResponseString() {
        if (this.response == null) {
            throw new RuntimeTestException("Response string is null : Check if the request is sent");
        }
        return this.responseBody;
    }

    private void createMap() {
        if (this.dataMap == null) {
            this.dataMap = new HashMap();
        }
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, Object>();
        }
        if (this.queryParamMap == null) {
            this.queryParamMap = new LinkedHashMap<String, Object>();
        }
    }
}

