/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.zephyrscale;

import com.tidal.stream.zephyrscale.ZephyrScalePublish;
import com.tidal.utils.csv.CsvData;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZephyrScaleTest {
    Logger logger = LoggerFactory.getLogger(ZephyrScaleTest.class);
    public static List<String> tags = new LinkedList<String>();
    String testTag;
    String testStatus;
    Function<String, String> readProperty = PropertiesFinder::getProperty;
    String patternMatcher;

    public ZephyrScaleTest testStatus(boolean status) {
        this.testStatus = status ? "Pass" : "Fail";
        return this;
    }

    public static String getJiraIdFromCSV() {
        CsvData csvData = new CsvData();
        csvData.setCSVFolderAsDataFilePath();
        return csvData.readDataFrom("TestLinkData", "Key");
    }

    public void publish() {
        HashMap<String, String> payLoad = new HashMap<String, String>();
        if (null != this.testTag) {
            payLoad.put("projectKey", this.readProperty.apply("projectKey"));
            payLoad.put("testCaseKey", this.testTag);
            payLoad.put("testCycleKey", this.readProperty.apply("testCycleKey"));
            payLoad.put("statusName", this.testStatus);
            String zephyrPublishResult = new ZephyrScalePublish().toZephyrScale(new JSONObject(payLoad).toString());
            this.logger.info("Result uploaded to Zephyr Scale");
            this.logger.info(zephyrPublishResult);
        } else {
            this.logger.info("No suitable Test Tag Found: Zephyr Scale Result is not published.");
        }
    }
}

