/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.browser;

import com.tidal.utils.data.GlobalData;
import dev.tidalcode.wave.browser.BrowserTypes;
import dev.tidalcode.wave.browser.Driver;
import dev.tidalcode.wave.data.DataCleaner;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.wait.Activity;
import java.time.Duration;
import java.util.HashMap;
import org.openqa.selenium.remote.AbstractDriverOptions;

public final class BrowserConfig {
    private String browserType;
    private AbstractDriverOptions<?> options;
    private Duration explicitWait;
    private final HashMap<Activity, Boolean> activityMap = new HashMap();
    private final Driver driver = new Driver();

    public BrowserConfig type(String browserType) {
        this.browserType = browserType;
        return this;
    }

    public BrowserConfig type(BrowserTypes browserType) {
        this.browserType = browserType.getBrowserName();
        return this;
    }

    public BrowserConfig withWaitTime(Duration explicitWait) {
        this.explicitWait = explicitWait;
        return this;
    }

    public BrowserConfig pageBackGroundActivity(Activity activity, boolean enable) {
        this.activityMap.put(activity, enable);
        return this;
    }

    public BrowserConfig withOptions(AbstractDriverOptions<?> options) {
        this.options = options;
        return this;
    }

    public void open(String url) {
        this.setOptionsAndCreateNewDriver(url);
    }

    public void close() {
        try {
            this.driver.close();
        }
        finally {
            DataCleaner.cleanData();
        }
    }

    private void setOptionsAndCreateNewDriver(String url) {
        this.setExplicitWaitTime();
        this.storePageBackGroundControlOptions();
        this.driver.create(this.browserType, this.options).navigateTo(url);
    }

    private void setExplicitWaitTime() {
        if (this.explicitWait != null) {
            WaitTimeData.setWaitTime(WaitTime.DEFAULT_WAIT_TIME, String.valueOf(this.explicitWait.getSeconds()));
        }
    }

    private void storePageBackGroundControlOptions() {
        if (!this.activityMap.isEmpty()) {
            this.activityMap.forEach((k, v) -> GlobalData.addData((String)k.getActivityType(), (String)String.valueOf(v)));
        }
    }
}

