/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.browser;

import com.tidal.utils.utils.CheckString;
import dev.tidalcode.wave.browser.Chrome;
import dev.tidalcode.wave.browser.Edge;
import dev.tidalcode.wave.browser.Firefox;
import java.util.Locale;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class BrowserFactory {
    public WebDriver getBrowser(String browser, AbstractDriverOptions<?> options) {
        if (CheckString.isNullOrEmpty((String)browser)) {
            return new Chrome().getDriver((ChromeOptions)options);
        }
        switch (browser.toUpperCase(Locale.ROOT)) {
            case "FIREFOX": {
                return new Firefox().getDriver((FirefoxOptions)options);
            }
            case "EDGE": {
                return new Edge().getDriver((EdgeOptions)options);
            }
            case "SAFARI": {
                return new SafariDriver((SafariOptions)options);
            }
        }
        return new Chrome().getDriver((ChromeOptions)options);
    }

    public WebDriver getBrowser() {
        return this.getBrowser(null, null);
    }
}

