/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.browser;

import dev.tidalcode.wave.browser.BrowserFactory;
import dev.tidalcode.wave.browser.DriverCommand;
import dev.tidalcode.wave.data.Store;
import java.util.Objects;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver {
    private final Logger logger = LoggerFactory.getLogger(Driver.class);
    private DriverCommand driverCommand;

    protected DriverCommand create(String browserType, AbstractDriverOptions<?> options) {
        WebDriver webDriver = Driver.getDriver();
        if (null == webDriver) {
            webDriver = new BrowserFactory().getBrowser(browserType, options);
        }
        Store.objectType("Driver", webDriver);
        this.driverCommand = new DriverCommand(webDriver);
        return this.driverCommand;
    }

    public void close() {
        this.logger.info("Quitting Driver");
        Objects.requireNonNull(this.driverCommand, "Driver is null. Attempting to close a browser which was not initiated or already closed?");
        this.driverCommand.closeDriver();
    }

    public static WebDriver getDriver() {
        return (WebDriver)Store.getTypeObject("Driver");
    }
}

