/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.command;

import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.ExecutorCommands;
import dev.tidalcode.wave.data.CommandStore;
import dev.tidalcode.wave.data.IntervalTime;
import dev.tidalcode.wave.data.MaxTime;
import java.beans.Introspector;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor
implements ExecutorCommands {
    private CommandContext context;
    private final int[] xyCordsArray = new int[2];
    private boolean isMultiple = false;
    private boolean isVisible = true;
    private String textInput;
    private String attributeName;
    private int selectIndex;
    private int tabIndex;
    private int hoverWaitTime;
    private double zoomLevel;
    private CharSequence[] sequence;
    private List<String> locators = new LinkedList<String>();
    private boolean shadowDomPresence;
    private int elementIndex;
    private boolean debugMode;
    private MaxTime maxTime;
    private IntervalTime intervalTime;
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    List<Command> commands = new LinkedList<Command>();

    Command getInstance(Class<? extends Command> inputClass) {
        String className = inputClass.getSimpleName();
        Command classInstance = null;
        try {
            classInstance = inputClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Exception thrown with class initiation for {}", (Object)className);
            logger.error(e.getMessage());
        }
        return classInstance;
    }

    public <U> U invokeCommand(Class<? extends Command> commandClass, String method) {
        this.setCommandContext();
        CommandContext context = this.getContext();
        Command command = this.getInstance(commandClass);
        command.contextSetter(context);
        return (U)command.execute(method);
    }

    public <U> U invokeCommand(Class<? extends Command> commandClass) {
        this.setCommandContext();
        CommandContext context = this.getContext();
        Command command = this.getInstance(commandClass);
        command.contextSetter(context);
        CommandStore.storeCommand(command);
        this.locators = context.getLocators();
        return (U)command.execute(Introspector.decapitalize(command.getClass().getSimpleName()));
    }

    @Override
    public void invokeCommand() {
        CommandStore.getCommands().forEach(c -> c.execute(Introspector.decapitalize(c.getClass().getSimpleName())));
    }

    @Override
    public void clearCommands() {
        this.commands.clear();
    }

    @Override
    public Executor withMultipleElements(boolean isTrue) {
        this.isMultiple = isTrue;
        return this;
    }

    @Override
    public Executor withText(String text) {
        this.textInput = text;
        return this;
    }

    @Override
    public Executor withTabIndex(int index) {
        this.tabIndex = index;
        return this;
    }

    @Override
    public Executor withTimeToWait(int seconds) {
        this.hoverWaitTime = seconds;
        return this;
    }

    @Override
    public Executor withAttribute(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    @Override
    public Executor withCharSequence(CharSequence ... sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    public Executor withSelectIndex(int index) {
        this.selectIndex = index;
        return this;
    }

    @Override
    public Executor isVisible(boolean visible) {
        this.isVisible = visible;
        return this;
    }

    @Override
    public Executor presenceOfShadowDom() {
        this.shadowDomPresence = true;
        return this;
    }

    @Override
    public Executor usingLocator(List<String> locators) {
        this.locators = locators;
        return this;
    }

    @Override
    public Executor withXYCords(int xCords, int yCords) {
        this.xyCordsArray[0] = xCords;
        this.xyCordsArray[1] = yCords;
        return this;
    }

    @Override
    public Executor withZoomLevel(double zoomLevel) {
        this.zoomLevel = zoomLevel;
        return this;
    }

    @Override
    public Executor withElementIndex(int index) {
        this.elementIndex = index;
        return this;
    }

    @Override
    public Executor pageRefreshData(MaxTime maxTime, IntervalTime intervalTime) {
        this.maxTime = maxTime;
        this.intervalTime = intervalTime;
        return this;
    }

    public Executor debugMode(boolean debugMode) {
        this.debugMode = debugMode;
        return this;
    }

    private void setCommandContext() {
        this.context = new CommandContext();
        this.context.setIntervalTime(this.intervalTime);
        this.context.setMaxRefreshTime(this.maxTime);
        this.context.setLocatorSet(this.locators);
        this.context.setDebugMode(this.debugMode);
        this.context.setAttributeName(this.attributeName);
        this.context.setMultiple(this.isMultiple);
        this.context.setVisibility(this.isVisible);
        this.context.setSequence(this.sequence);
        this.context.setElementIndex(this.elementIndex);
        this.context.setHoverWaitTime(this.hoverWaitTime);
        this.context.setShadowDomPresence(this.shadowDomPresence);
        this.context.setTabIndex(this.tabIndex);
        this.context.setZoomLevel(this.zoomLevel);
        this.context.setSelectIndex(this.selectIndex);
        this.context.setTextInput(this.textInput);
        this.context.setXYCords(this.xyCordsArray[0], this.xyCordsArray[1]);
    }

    public CommandContext getContext() {
        if (this.context == null) {
            this.setCommandContext();
        }
        return this.context;
    }
}

