/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import com.tidal.utils.filehandlers.Finder;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.exceptions.NoSuchFileException;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;

public class FileUploadWRC
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private String fileName;
    Function<CommandContext, Void> function = e -> {
        Robot robot;
        if (this.fileName.isEmpty()) {
            throw new IllegalArgumentException("File name should not be null or empty");
        }
        if (!Finder.findFileIfExists((String)this.fileName).isPresent()) {
            throw new NoSuchFileException(String.format("No file could be found with the given file name '%s'", this.fileName));
        }
        String filePath = Finder.findFilePath((String)this.fileName);
        WebElement element = this.webElement.getElement(this.context);
        element.click();
        try {
            robot = new Robot();
        }
        catch (AWTException ex) {
            throw new RuntimeException(ex);
        }
        StringSelection stringSelection = new StringSelection(filePath);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        robot.keyPress(17);
        robot.keyPress(86);
        robot.keyRelease(17);
        robot.keyRelease(86);
        robot.keyPress(10);
        robot.keyRelease(10);
        return Void.TYPE.cast(null);
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.fileName = context.getTextInput();
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    @Override
    protected Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void fileUploadAction() throws AWTException {
        this.function.apply(this.context);
    }

    public void fileUploadWRC() {
        this.timeCounter.restart();
        super.execute(Commands.InputCommands.UPLOAD_FILE.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

