/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import com.tidal.utils.utils.CheckString;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public final class FindAllTextData
extends CommandAction
implements Command<List<String>> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    Function<CommandContext, List<String>> function = e -> {
        Predicate<List> contentCheck = l -> l.stream().anyMatch(v -> !CheckString.isNullOrEmpty((String)v));
        List<WebElement> elements = this.webElement.getElements(this.context);
        List textContent = elements.stream().map(WebElement::getText).collect(Collectors.toList());
        if (contentCheck.test(textContent)) {
            return textContent;
        }
        textContent = elements.stream().map(v -> v.getDomAttribute("value")).collect(Collectors.toList());
        if (contentCheck.test(textContent)) {
            return textContent;
        }
        textContent = elements.stream().map(v -> v.getDomProperty("value")).collect(Collectors.toList());
        if (contentCheck.test(textContent)) {
            return textContent;
        }
        textContent = elements.stream().map(v -> v.getDomAttribute("innerHTML")).collect(Collectors.toList());
        if (contentCheck.test(textContent)) {
            return textContent;
        }
        textContent = elements.stream().map(v -> v.getDomProperty("innerHTML")).collect(Collectors.toList());
        return textContent;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, List<String>> getFunction() {
        return this.function;
    }

    @Override
    protected Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public List<String> findAllTextDataAction() {
        return this.function.apply(this.context);
    }

    public List<String> findAllTextData() {
        this.timeCounter.restart();
        return (List)super.execute(Commands.GetCommands.FIND_ALL_TEXT_DATA.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

