/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.exceptions.RuntimeTestException;
import dev.tidalcode.wave.page.Page;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.wait.ThreadSleep;
import dev.tidalcode.wave.webelement.Element;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageRefresh
extends CommandAction
implements Command<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(PageRefresh.class);
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private final TimeCounter pageRefreshTimeCounter = new TimeCounter();
    Function<CommandContext, Boolean> function = e -> {
        List<WebElement> elements = this.webElement.getElements(this.context);
        int maxTime = this.context.getMaxRefreshTime().getMaxTime();
        int intervalTime = this.context.getRefreshIntervalTime().getIntervalTime();
        while (elements.isEmpty()) {
            if (this.pageRefreshTimeCounter.timeElapsed(Duration.ofSeconds(maxTime))) {
                Object message = String.format("Element '%s' not found within the maximum time of %s seconds", this.context.getLocators().get(0), maxTime);
                message = (String)message + String.format("\nTotal time elapsed: %s seconds", this.pageRefreshTimeCounter.timeElapsed().getSeconds());
                throw new RuntimeTestException((String)message);
            }
            Page.refresh();
            ThreadSleep.forSeconds(intervalTime);
            elements = this.webElement.getElements(this.context);
        }
        logger.info("Page Refresh Action found " + elements.size() + " elements with locator " + this.context.getLocators().get(0));
        this.pageRefreshTimeCounter.restart();
        return true;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.context.setVisibility(false);
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Boolean> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public boolean pageRefreshAction() {
        return this.function.apply(this.context);
    }

    public boolean pageRefresh() {
        this.timeCounter.restart();
        return (Boolean)super.execute(Commands.PageCommands.REFRESH_PAGE_ACTION.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

