/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public final class SetValue
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private String inputText;
    Function<CommandContext, Void> function = e -> {
        Function<WebElement, String> expectedValue = v -> v.getDomProperty("value");
        WebElement element = this.webElement.getElement(this.context);
        ((JavascriptExecutor)((RemoteWebElement)element).getWrappedDriver()).executeScript(String.format("arguments[0].value='%s';", this.inputText), new Object[]{element});
        if (!expectedValue.apply(element).equals(this.inputText)) {
            element.clear();
            throw new ElementNotInteractableException("Element Not Interactable");
        }
        return Void.TYPE.cast(null);
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.inputText = context.getTextInput();
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.Of.sendKeys();
    }

    public void setValueAction() {
        this.function.apply(this.context);
    }

    public void setValue() {
        this.timeCounter.restart();
        super.execute(Commands.InputCommands.SET_VALUE.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

