/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.retry;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.retry.NotPresent;
import dev.tidalcode.wave.retry.NotVisible;
import dev.tidalcode.wave.retry.StillPresent;
import dev.tidalcode.wave.retry.StillVisible;
import java.util.function.Supplier;

public abstract class RetryCondition {
    public static final Supplier<RetryCondition> stillPresent = RetryCondition::stillPresent;
    public static final Supplier<RetryCondition> stillVisible = RetryCondition::stillVisible;

    public static RetryCondition notPresent(String locatorMatcher) {
        return new NotPresent(locatorMatcher);
    }

    public static RetryCondition notVisible(String locatorMatcher) {
        return new NotVisible(locatorMatcher);
    }

    private static RetryCondition stillPresent() {
        return new StillPresent();
    }

    private static RetryCondition stillVisible() {
        return new StillVisible();
    }

    public abstract boolean retry(Executor var1);
}

