/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.expectations.collections;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.GetSize;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.ExpectationFailure;
import dev.tidalcode.wave.exceptions.TimeoutException;
import dev.tidalcode.wave.verification.expectations.collections.Expectations;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.StaleElementReferenceException;

public class SizeLessThan
implements Expectations {
    private final Executor executor = new Executor();
    private final int size;
    private boolean result;

    public SizeLessThan(int size) {
        this.size = size;
    }

    @Override
    public void assertion(boolean isMultiple, List<String> locators) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected number of elements is %d but found %d element[s]", this.size, (int)((Integer)this.executor.isVisible(false).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(GetSize.class, "getSize")))).until(e -> (Integer)e.usingLocator(locators).withMultipleElements(isMultiple).invokeCommand(GetSize.class, "getSize") < this.size);
    }

    @Override
    public void orElseFail() {
        if (!this.result) {
            throw new ExpectationFailure(String.format("Expected number of elements is %d but found %d element[s]", this.size, (int)((Integer)this.executor.invokeCommand(GetSize.class, "getSize"))));
        }
    }
}

