/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.webelement;

import com.tidal.utils.data.GlobalData;
import com.tidal.utils.loggers.LoggerUtil;
import dev.tidalcode.wave.browser.Driver;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.IterationStopper;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.wait.Activity;
import dev.tidalcode.wave.wait.ActivityWaiter;
import dev.tidalcode.wave.wait.Wait;
import dev.tidalcode.wave.webelement.IframeIterator;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public class FindWebElement
extends IframeIterator {
    private static final LoggerUtil log = LoggerUtil.getLogger(FindWebElement.class);
    private final ActivityWaiter activityWaiter = (ActivityWaiter)ObjectSupplier.instanceOf(ActivityWaiter.class);
    private WebDriver driver;
    private WebDriverWait wait;
    private WebDriverWait backgroundActivityWait;

    public WebElement webElement(By locator) {
        return this.webElement(locator, true);
    }

    public WebElement webElement(By locator, boolean ensureVisibilityOfElement) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        log.elementsLog("Searching for element " + String.valueOf(locator));
        this.findFrameOfElement(locator, ensureVisibilityOfElement);
        log.elementsLog("Found Element " + String.valueOf(locator));
        return this.foundElement(this.driver);
    }

    public WebElement webElements(By locator, int index, boolean visibility) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        log.elementsLog("Searching for " + (index + 1) + " elements with locator " + String.valueOf(locator));
        try {
            this.switchToIframeOfElement(locator, visibility);
        }
        catch (IterationStopper iterationStopper) {
            // empty catch block
        }
        try {
            this.wait.until(d -> d.findElements(locator).size() - 1 >= index);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Expected %d elements, but found only %d element[s] in %d seconds", index + 1, this.driver.findElements(locator).size(), this.getWaitTime()));
        }
        List elements = (List)this.wait.until(d -> d.findElements(locator));
        if (elements.size() - 1 >= index) {
            return (WebElement)elements.get(index);
        }
        throw new TimeoutException(String.format("Expected %d elements, but found only %d element[s]", index + 1, elements.size()));
    }

    public List<WebElement> webElements(By locator, boolean visibility) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        log.elementsLog("Searching for elements " + String.valueOf(locator));
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        try {
            this.switchToIframeOfElement(locator, visibility);
        }
        catch (IterationStopper iterationStopper) {
            // empty catch block
        }
        List elements = (List)this.wait.until(d -> d.findElements(locator));
        if (!elements.isEmpty()) {
            log.elementsLog("Elements found " + String.valueOf(locator) + " is [" + elements.size() + "]");
        } else {
            log.elementsLog("No elements found " + String.valueOf(locator));
        }
        return elements;
    }

    private void findFrameOfElement(By locator, boolean visibility) {
        Function<WebDriver, Boolean> findElement = d -> {
            if (this.getBGCheck()) {
                this.waitForPageLoad((WebDriver)d, this.backgroundActivityWait);
            }
            try {
                return this.switchToIframeOfElement(locator, visibility);
            }
            catch (IterationStopper ignored) {
                return true;
            }
        };
        try {
            this.wait.until(findElement);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Element not found using %s in %d seconds \n %s", locator, this.getWaitTime(), e.getMessage()));
        }
    }

    private void waitForPageLoad(WebDriver driver, WebDriverWait wait) {
        try {
            this.activityWaiter.waitUntilDocReady(driver, wait);
            if (this.getJQueryCheck()) {
                this.activityWaiter.waitUntilJQueryReady(driver, wait);
            }
            if (this.getAngularCheck()) {
                this.activityWaiter.waitUntilAngularReady(driver, wait);
            }
            if (this.getAngular5Check()) {
                this.activityWaiter.waitUntilAngular5Ready(driver, wait);
            }
        }
        catch (Exception e) {
            log.elementsLog("Activity Waiter Exception Occurred");
        }
    }

    private WebElement foundElement(WebDriver driver) {
        WebElement element = this.contextElement;
        if (element.isDisplayed()) {
            String jsHighLighter = "arguments[0].style.border='1px dotted green'";
            ((JavascriptExecutor)driver).executeScript(jsHighLighter, new Object[]{element});
            return element;
        }
        return element;
    }

    private int getWaitTime() {
        String time = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        return Integer.parseInt(time);
    }

    protected boolean getBGCheck() {
        if (GlobalData.getData((String)Activity.ALL_ACTIVITIES_CHECK.getActivityType()) == null) {
            return true;
        }
        return Boolean.parseBoolean(GlobalData.getData((String)Activity.ALL_ACTIVITIES_CHECK.getActivityType()));
    }

    protected boolean getJQueryCheck() {
        if (GlobalData.getData((String)Activity.JQUERY_LOAD_WAITER.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData((String)Activity.JQUERY_LOAD_WAITER.getActivityType()));
    }

    protected boolean getAngularCheck() {
        if (GlobalData.getData((String)Activity.ANGULAR_CHECK.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData((String)Activity.ANGULAR_CHECK.getActivityType()));
    }

    protected boolean getAngular5Check() {
        if (GlobalData.getData((String)Activity.ANGULAR_5_CHECK.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData((String)Activity.ANGULAR_CHECK.getActivityType()));
    }
}

