/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.webelement;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.FindAllTextData;
import dev.tidalcode.wave.commands.GetSize;
import dev.tidalcode.wave.commands.IsPresent;
import dev.tidalcode.wave.tabsandwindows.Frames;
import dev.tidalcode.wave.verification.conditions.TestVerification;
import dev.tidalcode.wave.verification.conditions.collections.CollectionsCondition;
import dev.tidalcode.wave.verification.expectations.CollectionsSoftAssertion;
import dev.tidalcode.wave.verification.expectations.collections.Expectations;
import dev.tidalcode.wave.wait.ThreadSleep;
import dev.tidalcode.wave.wait.Wait;
import dev.tidalcode.wave.webelement.UIActions;
import dev.tidalcode.wave.webelement.UIElement;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UIElements
extends AbstractCollection<UIElement> {
    private UIActions uiActions;
    private boolean visibility;
    private int currentIndex = 0;
    private int size = -1;
    private final LinkedList<UIElement> dimensions = new LinkedList();

    @Override
    public Iterator<UIElement> iterator() {
        return new UIElementsIterator();
    }

    protected UIElements setProperties(String byLocator) {
        this.visibility = false;
        this.uiActions = new UIActions();
        this.uiActions.setProperties(byLocator);
        this.uiActions.setMultiple();
        return this;
    }

    protected void setElementProperties(UIActions uiActions) {
        this.uiActions = uiActions;
        this.visibility = false;
        uiActions.setMultiple();
    }

    protected UIElements withDefaultWait() {
        Wait.setDefaultWait();
        return this;
    }

    public UIElements visibleElements() {
        this.visibility = true;
        return this;
    }

    public UIElement get(int index) {
        this.uiActions.setElementIndex(index);
        return this.uiActions;
    }

    public UIElement first() {
        return this.get(0);
    }

    public UIElement last() {
        return this.get(this.size() - 1);
    }

    public void skipFirst() {
        this.currentIndex = 1;
    }

    public void skipLast() {
        this.size = this.size() - 1;
    }

    public UIElements waitFor(int waitTime) {
        Wait.setExplicitWait(waitTime);
        this.expecting(Expectations.sizeGreaterThan(0));
        return this;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof UIElement) {
            UIElement element = (UIElement)o;
            this.dimensions.remove(element);
            this.size = this.dimensions.size();
            return true;
        }
        return false;
    }

    public List<String> getAllText() {
        return (List)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(FindAllTextData.class);
    }

    @Override
    public int size() {
        this.size = (Integer)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(GetSize.class);
        if (this.dimensions.isEmpty()) {
            for (int i = 0; i < this.size; ++i) {
                this.dimensions.add(this.get(i));
            }
        }
        return this.size;
    }

    public UIElements inFrame(String locatorMatcher) {
        Frames.switchToFrame(locatorMatcher);
        return this;
    }

    public boolean isPresent() {
        return (Boolean)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(IsPresent.class);
    }

    public UIElements pause(int seconds) {
        ThreadSleep.forSeconds(seconds);
        return this;
    }

    public void shouldHave(CollectionsCondition ... condition) {
        TestVerification.verification(this.uiActions.getExecutor(), condition);
    }

    public Expectations expecting(Expectations expectations) {
        return CollectionsSoftAssertion.softAssert(true, this.uiActions.getLocators(), expectations);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    private class UIElementsIterator
    implements Iterator<UIElement> {
        private UIElementsIterator() {
        }

        @Override
        public boolean hasNext() {
            if (UIElements.this.size < 0) {
                UIElements.this.size = UIElements.this.size();
            }
            return UIElements.this.currentIndex < UIElements.this.size && UIElements.this.get(UIElements.this.currentIndex) != null;
        }

        @Override
        public UIElement next() {
            return UIElements.this.dimensions.get(UIElements.this.currentIndex++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

