/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.command;

import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.config.Config;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.MethodInvokerException;
import dev.tidalcode.wave.exceptions.RuntimeTestException;
import dev.tidalcode.wave.stackbuilder.ErrorStack;
import dev.tidalcode.wave.wait.ThreadSleep;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Command<T> {
    public static final Logger logger = LoggerFactory.getLogger(Command.class);

    public void contextSetter(CommandContext var1);

    public CommandContext getCommandContext();

    public Function<CommandContext, T> getFunction();

    default public <X> X execute(String action) {
        Object value;
        CommandContext commandContext = this.getCommandContext();
        if (Config.SLOW_RUN) {
            ThreadSleep.forSeconds(1.0);
        }
        if (commandContext.getDebugMode() || Config.DEBUG) {
            logger.info("Executing action '" + action.replace("Action", "").toUpperCase() + "'");
            logger.info(commandContext.toString());
        }
        Class<?> klass = this.getClass();
        try {
            Method method = klass.getDeclaredMethod(action, new Class[0]);
            value = method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MethodInvokerException(String.format("No such method with name '%s', in class '%s'", action, klass.getName()), e);
        }
        catch (InvocationTargetException e) {
            if (commandContext.getDebugMode() || Config.DEBUG) {
                e.printStackTrace();
            }
            String errorDetail = e.getCause().getMessage();
            errorDetail = new ErrorStack().constructedError(errorDetail, Thread.currentThread().getStackTrace());
            throw new RuntimeTestException(String.format("Exception caused from action '%s' %s", action, errorDetail));
        }
        catch (IllegalAccessException e) {
            throw new MethodInvokerException(String.format("Method '%s', in class '%s' has got private/protected access", action, klass.getName()), e);
        }
        return (X)value;
    }

    default public <Y> Y executeAction(Function<CommandContext, Y> function) {
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME));
        try {
            return function.apply(this.getCommandContext());
        }
        catch (Exception e) {
            ThreadSleep.forSeconds((double)duration / 2.0);
            return function.apply(this.getCommandContext());
        }
    }
}

