/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.commands;

import com.tidal.utils.counter.TimeCounter;
import dev.tidalcode.wave.command.Command;
import dev.tidalcode.wave.command.CommandAction;
import dev.tidalcode.wave.command.CommandContext;
import dev.tidalcode.wave.command.Commands;
import dev.tidalcode.wave.exceptions.CommandExceptions;
import dev.tidalcode.wave.exceptions.RuntimeTestException;
import dev.tidalcode.wave.supplier.ObjectSupplier;
import dev.tidalcode.wave.webelement.Element;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebElement;

public final class DragAndDrop
extends CommandAction
implements Command<Void> {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private List<String> locators;
    Function<CommandContext, Void> function = e -> {
        if (this.locators.size() <= 1) {
            throw new RuntimeTestException("Expecting two locators but found only one. \nFor drag and drop two web elements needed to be found. \nUse the format find(StringLocator(x)).thenFind(StringLocator(y)).dragAndDrop(); ");
        }
        LinkedList<String> linkedListOne = new LinkedList<String>();
        linkedListOne.add(this.locators.get(0));
        this.context.setLocatorSet(linkedListOne);
        WebElement sourceElement = this.webElement.getElement(this.context);
        LinkedList<String> linkedListTwo = new LinkedList<String>();
        linkedListTwo.add(this.locators.get(1));
        this.context.setLocatorSet(linkedListTwo);
        WebElement targetElement = this.webElement.getElement(this.context);
        new Actions(((RemoteWebElement)sourceElement).getWrappedDriver()).dragAndDrop(sourceElement, targetElement).perform();
        return null;
    };

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.context.setVisibility(false);
        this.locators = context.getLocators();
    }

    @Override
    public CommandContext getCommandContext() {
        return this.context;
    }

    @Override
    public Function<CommandContext, Void> getFunction() {
        return this.function;
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void dragAndDropAction() {
        this.function.apply(this.context);
    }

    public void dragAndDrop() {
        this.timeCounter.restart();
        super.execute(Commands.MoveCommands.DRAG_AND_DROP.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

