/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.httpRequest;

import com.tidal.utils.exceptions.PropertyHandlerException;
import com.tidal.utils.exceptions.RuntimeTestException;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import dev.tidalcode.wave.httpRequest.DataEnum;
import dev.tidalcode.wave.httpRequest.ReqType;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FluentRequest {
    private final Function<String, String> timeOut = PropertiesFinder::getProperty;
    private final String BASE_URI = "baseURI";
    private final String MEDIA_TYPE = "mediaType";
    private final String PAYLOAD = "payload";
    private final String RESPONSE_STRING = "responseString";
    private final String QUERY_PARAM_ONE_KEY = "queryParamOneKey";
    private final String QUERY_PARAM_TWO_KEY = "queryParamTwoKey";
    private final OkHttpClient CLIENT;
    private Response RESPONSE;
    private Request HTTP_REQUEST;
    private HashMap<String, Object> DATA_MAP;
    private Map<String, Object> HEADER_MAP;
    private Headers REQUEST_HEADERS;
    private HttpUrl.Builder builder;
    private final UnaryOperator<String> readTimeOut = s -> {
        try {
            return this.timeOut.apply((String)s) == null ? "10" : this.timeOut.apply((String)s);
        }
        catch (PropertyHandlerException ignored) {
            return "10";
        }
    };

    public FluentRequest() {
        this.createMap();
        this.CLIENT = this.getNewOkHttpClient();
    }

    public void setHttpRequest(Request builtRequest) {
        this.HTTP_REQUEST = builtRequest;
    }

    public FluentRequest set(String baseUri) {
        this.DATA_MAP.put("baseURI", baseUri);
        return this;
    }

    public FluentRequest setBaseUri(String baseUri) {
        this.DATA_MAP.put("baseURI", baseUri);
        return this;
    }

    public FluentRequest setMediaType(String mediaType) {
        this.DATA_MAP.put("mediaType", mediaType);
        return this;
    }

    private OkHttpClient getNewOkHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("connection.timeout")))).readTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("read.timeout")))).writeTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("write.timeout")))).callTimeout(Duration.ofSeconds(Integer.parseInt((String)this.readTimeOut.apply("call.timeout")))).build();
    }

    public FluentRequest setHeader(String key, Object value) {
        this.HEADER_MAP.put(key, value);
        return this;
    }

    public FluentRequest setQueryParams(String key, Object value) {
        if (this.DATA_MAP.get("queryParamOneKey") == null) {
            this.DATA_MAP.put("queryParamOneKey", key);
            this.DATA_MAP.put("queryParamOneValue", value);
        } else if (this.DATA_MAP.get("queryParamTwoKey") == null) {
            this.DATA_MAP.put("queryParamTwoKey", key);
            this.DATA_MAP.put("queryParamTwoValue", value);
        }
        return this;
    }

    public FluentRequest setQueryParams2(String key, Object value) {
        this.builder.addQueryParameter((String)this.DATA_MAP.get("queryParamOneKey"), (String)this.DATA_MAP.get("queryParamOneValue"));
        return this;
    }

    public FluentRequest setPayload(String payload) {
        this.DATA_MAP.put("payload", payload);
        return this;
    }

    public <T> FluentRequest setData(String key, T value) {
        this.DATA_MAP.put(key, value);
        return this;
    }

    public <T> FluentRequest setData(DataEnum data, T value) {
        this.DATA_MAP.put(data.getValue(), value);
        return this;
    }

    public <T> T getData(String key) {
        return (T)this.DATA_MAP.get(key);
    }

    public <T> Optional<T> getData(DataEnum data) {
        Object value = this.DATA_MAP.get(data.getValue());
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public FluentRequest send(ReqType reqType) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        if (this.DATA_MAP.get("mediaType") != null) {
            mediaType = MediaType.parse((String)((String)this.DATA_MAP.get("mediaType")));
        }
        RequestBody body = RequestBody.create((String)"", (MediaType)mediaType);
        if (this.DATA_MAP.get("payload") != null) {
            body = RequestBody.create((String)((String)this.DATA_MAP.get("payload")), (MediaType)mediaType);
        }
        this.applyHeaders();
        if (this.HTTP_REQUEST == null) {
            Request.Builder requestBuilder = new Request.Builder().url(this.queryBuilder().build());
            switch (reqType) {
                case GET: {
                    this.HTTP_REQUEST = requestBuilder.get().headers(this.REQUEST_HEADERS).build();
                    break;
                }
                case HEAD: {
                    this.HTTP_REQUEST = requestBuilder.head().headers(this.REQUEST_HEADERS).build();
                    break;
                }
                case DELETE: {
                    this.HTTP_REQUEST = requestBuilder.delete().headers(this.REQUEST_HEADERS).build();
                    break;
                }
                default: {
                    this.HTTP_REQUEST = requestBuilder.method(reqType.getReqType().toUpperCase(Locale.ROOT), body).headers(this.REQUEST_HEADERS).build();
                }
            }
        }
        try {
            this.RESPONSE = this.CLIENT.newCall(this.HTTP_REQUEST).execute();
        }
        catch (IOException e) {
            throw new RuntimeTestException("IOException with request" + e.getMessage());
        }
        return this;
    }

    private HttpUrl.Builder queryBuilder() {
        HttpUrl.Builder builder = HttpUrl.get((String)((String)this.DATA_MAP.get("baseURI"))).newBuilder();
        if (this.DATA_MAP.get("queryParamOneKey") != null) {
            builder.addQueryParameter((String)this.DATA_MAP.get("queryParamOneKey"), (String)this.DATA_MAP.get("queryParamOneValue"));
        }
        if (this.DATA_MAP.get("queryParamTwoKey") != null) {
            builder.addQueryParameter((String)this.DATA_MAP.get("queryParamTwoKey"), (String)this.DATA_MAP.get("queryParamTwoValue"));
        }
        return builder;
    }

    private void applyHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        for (String key : this.HEADER_MAP.keySet()) {
            headerBuilder.add(key, (String)Objects.requireNonNull(this.HEADER_MAP.get(key)));
        }
        this.REQUEST_HEADERS = headerBuilder.build();
    }

    public Response response() {
        if (this.RESPONSE == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return this.RESPONSE;
    }

    public int getStatusCode() {
        if (this.RESPONSE == null) {
            throw new RuntimeTestException("Status code is null : Check if the request is sent");
        }
        return this.RESPONSE.code();
    }

    public String getResponseString() {
        if (this.RESPONSE == null) {
            throw new RuntimeTestException("Response string is null : Check if the request is sent");
        }
        try {
            if (this.DATA_MAP.get("responseString") == null) {
                this.DATA_MAP.put("responseString", this.RESPONSE.body().string());
            }
            return (String)this.DATA_MAP.get("responseString");
        }
        catch (IOException e) {
            throw new RuntimeTestException("IO Exception with response: " + e.getMessage());
        }
    }

    private void createMap() {
        if (this.DATA_MAP == null) {
            this.DATA_MAP = new HashMap();
        }
        if (this.HEADER_MAP == null) {
            this.HEADER_MAP = new HashMap<String, Object>();
        }
    }
}

