/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.httpRequest;

import dev.tidalcode.wave.httpRequest.DataEnum;
import dev.tidalcode.wave.httpRequest.FluentRequest;
import dev.tidalcode.wave.httpRequest.ReqType;
import java.util.Optional;
import okhttp3.Response;

public class Request {
    private static final ThreadLocal<FluentRequest> FLUENT_REQUEST = ThreadLocal.withInitial(FluentRequest::new);

    private Request() {
    }

    public static void setHttpRequest(okhttp3.Request builtRequest) {
        FLUENT_REQUEST.get().setHttpRequest(builtRequest);
    }

    public static void set(String baseUri) {
        FLUENT_REQUEST.get().set(baseUri);
    }

    public static void setBaseUri(String baseUri) {
        FLUENT_REQUEST.get().set(baseUri);
    }

    public static void setMediaType(String mediaType) {
        FLUENT_REQUEST.get().setMediaType(mediaType);
    }

    public static void reset() {
        FLUENT_REQUEST.remove();
    }

    public static void setHeader(String key, Object value) {
        FLUENT_REQUEST.get().setHeader(key, value);
    }

    public static void setQueryParams(String key, Object value) {
        FLUENT_REQUEST.get().setQueryParams(key, value);
    }

    public static void setPayload(String payload) {
        FLUENT_REQUEST.get().setPayload(payload);
    }

    public static <T> void setData(String key, T value) {
        FLUENT_REQUEST.get().setData(key, value);
    }

    public static <T> void setData(DataEnum data, T value) {
        FLUENT_REQUEST.get().setData(data, value);
    }

    public static <T> T getData(String key) {
        return FLUENT_REQUEST.get().getData(key);
    }

    public static <T> Optional<T> getData(DataEnum data) {
        return FLUENT_REQUEST.get().getData(data);
    }

    public static void send(ReqType reqType) {
        try {
            FLUENT_REQUEST.get().send(reqType);
        }
        catch (Exception e) {
            Request.reset();
            throw new RuntimeException("IOException with request" + e.getMessage());
        }
    }

    public static Response response() {
        return FLUENT_REQUEST.get().response();
    }

    public static int getStatusCode() {
        return FLUENT_REQUEST.get().getStatusCode();
    }

    public static String getResponseString() {
        return FLUENT_REQUEST.get().getResponseString();
    }
}

