/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.locator;

import dev.tidalcode.wave.exceptions.PendingException;
import dev.tidalcode.wave.locator.LocatorParser;
import dev.tidalcode.wave.locator.Parser;
import org.openqa.selenium.By;

public class LocatorMatcher {
    private static final LocatorParser idParser = new Parser.IdParser();
    private static final LocatorParser xpathParser = new Parser.XPathParser();
    private static final LocatorParser nameTagNameParser = new Parser.NameTagNameParser();
    private static final LocatorParser linkTextParser = new Parser.LinkTextParser();
    private static final LocatorParser cssParser = new Parser.CSSParser();
    private static final LocatorParser classParser = new Parser.ClassParser();
    private static final LocatorParser textParser = new Parser.TextParser();
    private static final LocatorParser locatorParser;

    private LocatorMatcher() {
    }

    public static By getMatchedLocator(String locatorMatcher) {
        if (locatorMatcher.equalsIgnoreCase("//pending")) {
            throw new PendingException("This locator is pending to be added");
        }
        return locatorParser.parse(locatorMatcher);
    }

    static {
        idParser.setNextParser(xpathParser);
        xpathParser.setNextParser(nameTagNameParser);
        nameTagNameParser.setNextParser(linkTextParser);
        linkTextParser.setNextParser(cssParser);
        cssParser.setNextParser(classParser);
        classParser.setNextParser(textParser);
        locatorParser = idParser;
    }
}

