/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.supplier;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSupplier {
    private static final Logger logger = LoggerFactory.getLogger(ObjectSupplier.class);
    private static final ThreadLocal<Map<String, Object>> objectMap = ThreadLocal.withInitial(() -> new ConcurrentHashMap(200));

    private ObjectSupplier() {
    }

    public static <T> Object instanceOf(Class<T> klass) {
        String className = klass.getSimpleName();
        Object objectStored = objectMap.get().get(className);
        if (objectStored != null) {
            return objectStored;
        }
        try {
            Constructor<T> constructor = klass.getConstructor(new Class[0]);
            T newObject = constructor.newInstance(new Object[0]);
            objectMap.get().put(className, newObject);
            return newObject;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage());
            throw new ExceptionInInitializerError(String.format("Failed to initialize class %s", className));
        }
    }

    public static void addInstance(Object object) {
        String className = object.getClass().getSimpleName();
        objectMap.get().put(className, object);
    }

    public static void addSuperInstance(Object object) {
        String superClassName = object.getClass().getSuperclass().getSimpleName();
        objectMap.get().put(superClassName, object);
    }

    public static void flushInstances() {
        objectMap.get().forEach((k, v) -> {
            v = null;
        });
        objectMap.remove();
    }

    public static void flushInstance(Object object) {
        objectMap.get().remove(object.getClass().getSimpleName());
    }
}

