/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.verification.expectations;

import dev.tidalcode.wave.command.Executor;
import dev.tidalcode.wave.commands.FindTextData;
import dev.tidalcode.wave.data.WaitTime;
import dev.tidalcode.wave.data.WaitTimeData;
import dev.tidalcode.wave.exceptions.TimeoutException;
import dev.tidalcode.wave.verification.expectations.Expectation;
import dev.tidalcode.wave.wait.FluentWait;
import java.time.Duration;
import org.openqa.selenium.StaleElementReferenceException;

public class NewTextValueExpectation
extends Expectation {
    String existingValue;

    @Override
    public void assertion(Executor executor) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.existingValue = (String)executor.invokeCommand(FindTextData.class, "findTextData");
        this.result = new FluentWait<Executor>(executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Existing value '%s' has not changed", this.existingValue)).until(e -> !e.invokeCommand(FindTextData.class, "findTextData").toString().equals(this.existingValue));
    }

    @Override
    public void orElseFail() {
        super.orElseFail(String.format("Existing value '%s' has not changed", this.existingValue));
    }
}

