/*
 * Decompiled with CFR 0.152.
 */
package dev.tidalcode.wave.wait;

import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityWaiter {
    private final Logger logger = LoggerFactory.getLogger(ActivityWaiter.class);

    public void waitAllRequest(WebDriver driver, WebDriverWait wait) {
        this.waitUntilDocReady(driver, wait);
        this.waitUntilJQueryReady(driver, wait);
        this.waitUntilAngularReady(driver, wait);
        this.waitUntilAngular5Ready(driver, wait);
    }

    public void waitUntilDocReady(WebDriver driver, WebDriverWait wait) {
        try {
            Function<WebDriver, Boolean> jsLoad = d -> ((JavascriptExecutor)d).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            boolean jsReady = ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            if (!jsReady) {
                this.logger.warn("Document not in ready state, Waiting for background process to be completed");
                wait.until(jsLoad);
            }
        }
        catch (WebDriverException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void waitUntilJQueryReady(WebDriver driver, WebDriverWait wait) {
        boolean jQueryDefined = (Boolean)((JavascriptExecutor)driver).executeScript("return typeof jQuery != 'undefined'", new Object[0]);
        if (jQueryDefined) {
            this.waitForJQueryLoad(driver, wait);
        }
    }

    private void waitForJQueryLoad(WebDriver driver, WebDriverWait wait) {
        Function<WebDriver, Boolean> jQueryLoad = d -> (Long)((JavascriptExecutor)d).executeScript("return jQuery.active", new Object[0]) == 0L;
        boolean jqueryReady = (Boolean)((JavascriptExecutor)driver).executeScript("return jQuery.active==0", new Object[0]);
        if (!jqueryReady) {
            this.logger.warn("Document not in ready state, Waiting for JQUERY loading to finish");
            wait.until(jQueryLoad);
        }
    }

    public void waitUntilAngularReady(WebDriver driver, WebDriverWait wait) {
        JavascriptExecutor jsExecDriver = (JavascriptExecutor)driver;
        try {
            boolean angularUnDefined = (Boolean)jsExecDriver.executeScript("return window.angular === undefined", new Object[0]);
            if (!angularUnDefined) {
                this.logger.warn("Document not in ready state, Waiting for Angular Activities to finish");
                boolean angularInjectorUnDefined = (Boolean)jsExecDriver.executeScript("return angular.element(document).injector() === undefined", new Object[0]);
                if (!angularInjectorUnDefined) {
                    this.waitForAngularLoad(driver, wait);
                }
            }
        }
        catch (WebDriverException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void waitForAngularLoad(WebDriver driver, WebDriverWait wait) {
        String angularReadyScript = "return angular.element(document).injector().get('$http').pendingRequests.length === 0";
        this.angularLoads(angularReadyScript, driver, wait);
    }

    public void waitUntilAngular5Ready(WebDriver driver, WebDriverWait wait) {
        JavascriptExecutor jsExecDriver = (JavascriptExecutor)driver;
        try {
            Object angular5Check = jsExecDriver.executeScript("return getAllAngularRootElements()[0].attributes['ng-version']", new Object[0]);
            if (angular5Check != null) {
                this.logger.warn("Document not in ready state, Waiting for Angular5 activities to finish");
                boolean angularPageLoaded = (Boolean)jsExecDriver.executeScript("return window.getAllAngularTestabilities().findIndex(x=>!x.isStable()) === -1", new Object[0]);
                if (!angularPageLoaded) {
                    this.waitForAngular5Load(driver, wait);
                }
            }
        }
        catch (WebDriverException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void waitForAngular5Load(WebDriver driver, WebDriverWait wait) {
        String angularReadyScript = "return window.getAllAngularTestabilities().findIndex(x=>!x.isStable()) === -1";
        this.angularLoads(angularReadyScript, driver, wait);
    }

    private void angularLoads(String angularReadyScript, WebDriver driver, WebDriverWait wait) {
        try {
            Function<WebDriver, Boolean> angularLoad = d -> Boolean.valueOf(((JavascriptExecutor)d).executeScript(angularReadyScript, new Object[0]).toString());
            boolean angularReady = Boolean.parseBoolean(((JavascriptExecutor)driver).executeScript(angularReadyScript, new Object[0]).toString());
            if (!angularReady) {
                wait.until(angularLoad);
            }
        }
        catch (WebDriverException e) {
            this.logger.error(e.getMessage());
        }
    }
}

